<?php
/**
 * Register YOLO Course.
 * This file register Item and Category for YOLO Course.
 *
 * @package    YOLO Framework
 * @subpackage YOLO Course
 * @version    1.0.0
 * @author     GDragon <longdt@yolotheme.com>
 * @copyright  Copyright (c) 2015, YoloTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://yolotheme.com
 */

if( !class_exists('Yolo_Course') ):

    class Yolo_Course {

        public function __construct() {
            add_action( 'init', array($this, 'yolo_course_register_post_type' ));
            add_action( 'save_post', array( &$this, 'yolo_course_save_learning_skills_meta_box'), 1, 2 );
            add_action( 'save_post', array( &$this, 'yolo_course_save_quality_meta_box'), 1, 2 );
            add_action( 'save_post', array( &$this, 'yolo_course_save_course_teacher_meta_box'), 1, 2 );
            add_action( 'save_post', array( &$this, 'yolo_course_save_testimonials_meta_box'), 1, 2 );
            add_action( 'save_post', array( &$this, 'yolo_course_save_class_time_meta_box'), 1, 2 );
            add_action ( 'admin_enqueue_scripts', array( &$this,'yolo_admin_enqueue_scripts' ));
            if( is_admin() ) {
                add_action('add_meta_boxes', array($this,'yolo_course_register_meta_box'));
            }
        }

        public function yolo_admin_enqueue_scripts() {
            wp_register_style( 'yolo-style-admin', YOLO_PLUGIN_PATH . '/assets/css/yolo-admin.css' );
            wp_enqueue_style( 'yolo-style-admin' );
            wp_enqueue_style( 'yolo-course', YOLO_FRAMEWORK_URI . '/assets/css/yolo-course.css');
            wp_enqueue_script('yolo-properties-admin', YOLO_PLUGIN_PATH . '/assets/js/properties.js', array('jquery'), null, true );

        }

        public function yolo_course_register_post_type() {

            // Text for YOLO Course.
            $course_labels = array(
                'name'                  => esc_html__( 'Courses', 'yolo-kidzone' ) ,
                'singular_name'         => esc_html__( 'Courses', 'yolo-kidzone' ) ,
                'menu_name'             => esc_html__( 'Courses', 'yolo-kidzone' ) ,
                'add_new'               => esc_html__( 'Add New', 'yolo-kidzone' ) ,
                'add_new_item'          => esc_html__( 'Add New Course Item', 'yolo-kidzone' ) ,
                'edit_item'             => esc_html__( 'Edit Course Item', 'yolo-kidzone' ) ,
                'new_item'              => esc_html__( 'Add New Course Item', 'yolo-kidzone' ) ,
                'view_item'             => esc_html__( 'View Course', 'yolo-kidzone' ) ,
                'search_items'          => esc_html__( 'Search Course', 'yolo-kidzone' ) ,
                'not_found'             => esc_html__( 'No Course items found', 'yolo-kidzone' ) ,
                'not_found_in_trash'    => esc_html__( 'No Course items found in trash', 'yolo-kidzone' ) ,
                'parent_item_colon'     => ''
            );

            $admin_icon = YOLO_PLUGIN_PATH . '/assets/images/yolo20x20.png';
            if ( floatval( get_bloginfo( 'version' ) ) >= 3.8 ) {
                $admin_icon = 'dashicons-welcome-learn-more';
            }

            $course_slug = 'course';

            // Options
            $course_args = array(
                'labels'                => $course_labels,
                'public'                => true,
                'publicly_queryable'    => true,
                'show_ui'               => true,
                'show_in_nav_menus'     => true,
                'show_in_menu'          => true,
                'menu_position'         => 5,
                'menu_icon'             => $admin_icon,
                'capability_type'       => 'post',
                'hierarchical'          => false,
                'supports'              => array(
                    'title',
                    'editor',
                    'excerpt',
                    'thumbnail',
                    'comments',
                    'revisions'
                ) ,
                'has_archive'           => true,
                'rewrite'               => array(
                    'slug'          => $course_slug,
                    'with_front'    => false
                )
            );

            register_post_type( 'course', $course_args );

            // Register a taxonomy for Course Categories.
            $category_labels = array(
                'name'                          => esc_html__( 'Course Categories', 'yolo-kidzone' ) ,
                'singular_name'                 => esc_html__( 'Course Category', 'yolo-kidzone' ) ,
                'menu_name'                     => esc_html__( 'Course Categories', 'yolo-kidzone' ) ,
                'all_items'                     => esc_html__( 'All Course Categories', 'yolo-kidzone' ) ,
                'edit_item'                     => esc_html__( 'Edit Course Category', 'yolo-kidzone' ) ,
                'view_item'                     => esc_html__( 'View Course Category', 'yolo-kidzone' ) ,
                'update_item'                   => esc_html__( 'Update Course Category', 'yolo-kidzone' ) ,
                'add_new_item'                  => esc_html__( 'Add New Course Category', 'yolo-kidzone' ) ,
                'new_item_name'                 => esc_html__( 'New Course Category Name', 'yolo-kidzone' ) ,
                'parent_item'                   => esc_html__( 'Parent Course Category', 'yolo-kidzone' ) ,
                'parent_item_colon'             => esc_html__( 'Parent Course Category:', 'yolo-kidzone' ) ,
                'search_items'                  => esc_html__( 'Search Course Categories', 'yolo-kidzone' ) ,
                'popular_items'                 => esc_html__( 'Popular Course Categories', 'yolo-kidzone' ) ,
                'separate_items_with_commas'    => esc_html__( 'Separate Course Categories with commas', 'yolo-kidzone' ) ,
                'add_or_remove_items'           => esc_html__( 'Add or remove Course Categories', 'yolo-kidzone' ) ,
                'choose_from_most_used'         => esc_html__( 'Choose from the most used Course Categories', 'yolo-kidzone' ) ,
                'not_found'                     => esc_html__( 'No Course Categories found', 'yolo-kidzone' ) ,
            );

            $category_args = array(
                'labels'                        => $category_labels,
                'public'                        => false,
                'show_ui'                       => true,
                'show_in_nav_menus'             => false,
                'show_tagcloud'                 => false,
                'show_admin_column'             => true,
                'hierarchical'                  => true,
                'query_var'                     => true,
                'rewrite'                       => array(
                    'slug'          => 'course_category',
                    'with_front'    => false
                ) ,
            );

            register_taxonomy( 'course_category', array(
                'course'
            ) , $category_args);

            // Register a taxonomy for Course Levels.
            $level_labels = array(
                'name'                          => esc_html__( 'Course Levels', 'yolo-kidzone' ) ,
                'singular_name'                 => esc_html__( 'Course Level', 'yolo-kidzone' ) ,
                'menu_name'                     => esc_html__( 'Course Levels', 'yolo-kidzone' ) ,
                'all_items'                     => esc_html__( 'All Course Levels', 'yolo-kidzone' ) ,
                'edit_item'                     => esc_html__( 'Edit Course Level', 'yolo-kidzone' ) ,
                'view_item'                     => esc_html__( 'View Course Level', 'yolo-kidzone' ) ,
                'update_item'                   => esc_html__( 'Update Course Level', 'yolo-kidzone' ) ,
                'add_new_item'                  => esc_html__( 'Add New Course Level', 'yolo-kidzone' ) ,
                'new_item_name'                 => esc_html__( 'New Course Level Name', 'yolo-kidzone' ) ,
                'parent_item'                   => esc_html__( 'Parent Course Level', 'yolo-kidzone' ) ,
                'parent_item_colon'             => esc_html__( 'Parent Course Level:', 'yolo-kidzone' ) ,
                'search_items'                  => esc_html__( 'Search Course Levels', 'yolo-kidzone' ) ,
                'popular_items'                 => esc_html__( 'Popular Course Levels', 'yolo-kidzone' ) ,
                'separate_items_with_commas'    => esc_html__( 'Separate Course Levels with commas', 'yolo-kidzone' ) ,
                'add_or_remove_items'           => esc_html__( 'Add or remove Course Levels', 'yolo-kidzone' ) ,
                'choose_from_most_used'         => esc_html__( 'Choose from the most used Course Levels', 'yolo-kidzone' ) ,
                'not_found'                     => esc_html__( 'No Course Levels found', 'yolo-kidzone' ) ,
            );

            $level_args = array(
                'labels'                        => $level_labels,
                'public'                        => false,
                'show_ui'                       => true,
                'show_in_nav_menus'             => false,
                'show_tagcloud'                 => false,
                'show_admin_column'             => true,
                'hierarchical'                  => true,
                'query_var'                     => true,
                'rewrite'                       => array(
                    'slug'          => 'course_level',
                    'with_front'    => false
                ) ,
            );

            register_taxonomy( 'course_level', array(
                'course'
            ) , $level_args);
        }

        public function yolo_course_register_meta_box(){
            // Declare helper object
            $prefix = '_yolo_wp_post';
            $helper = new YOLO_Meta_Boxes_Helper($prefix, array(
                'page' => 'course'
            ));
            // Information fields
            $meta_box = array(
                'id'                => "{$prefix}_meta_box_course",
                'title'             => esc_html__( 'Course options', 'yolo-kidzone' ),
                'fields'            => array(
                    array(
                        'id'    => "{$prefix}_price",
                        'label' => esc_html__( 'Course Price', 'yolo-kidzone' ),
                        'type'  => 'text',
                    ),
                    array(
                        'id'    => "{$prefix}_phone",
                        'label' => esc_html__( 'Course Phone', 'yolo-kidzone' ),
                        'type'  => 'text',
                    ),
                    array(
                        'id'    => "{$prefix}_email",
                        'label' => esc_html__( 'Course Email', 'yolo-kidzone' ),
                        'type'  => 'text',
                    ),
                    array(
                        'id'    => "{$prefix}_review",
                        'label' => esc_html__( 'Course Review', 'yolo-kidzone' ),
                        'type'  => 'select',
                        'std'   => '5',
                        'options' => array(
                            '1' => array(
                                'label' => esc_html__( '1 Star', 'yolo-kidzone' ),
                                'value' => '1',
                            ),
                            '2' => array(
                                'label' => esc_html__( '2 Star', 'yolo-kidzone' ),
                                'value' => '2',
                            ),

                            '3' => array(
                                'label' => esc_html__( '3 Star', 'yolo-kidzone' ),
                                'value' => '3',
                            ),
                            '4' => array(
                                'label' => esc_html__( '4 Star', 'yolo-kidzone' ),
                                'value' => '4',
                            ),
                            '5' => array(
                                'label' => esc_html__( '5 Star', 'yolo-kidzone' ),
                                'value' => '5',
                            ),

                        ),
                    ),
                )
            );

            $helper->add_meta_box( $meta_box );

            // Course Teacher
            $meta_box = array(
                'id'        => "{$prefix}_meta_box_course_teacher",
                'title'     => esc_html__( 'Course Teacher', 'yolo-kidzone' ),
                'fields'    => array(
                    array(
                        'id'        => "{$prefix}_course_teacher",
                        'label'     => esc_html__( 'Choose Teacher', 'yolo-kidzone' ),
                        'type'      => 'course_teacher',
                        'callback'  =>  array( $this, 'yolo_course_meta_box_course_teacher_callback' )
                    ),
                )
            );

            $helper->add_meta_box($meta_box);

            // Course Testimonials
            $meta_box = array(
                'id'        => "{$prefix}_course_meta_box_testimonials",
                'title'     => esc_html__( 'Course Testimonials', 'yolo-kidzone' ),
                'fields'    => array(
                    array(
                        'id'        => "{$prefix}_course_testimonials",
                        'type'      => 'testimonials',
                        'label'     => esc_html__( 'Select Testimonials', 'yolo-kidzone' ),
                        'callback'  =>  array( $this, 'yolo_course_testimonials_meta_box_callback' )
                    ),
                    array(
                        'id'    => "{$prefix}_testimonial_columns",
                        'label' => esc_html__( 'Testimonial Columns', 'yolo-kidzone' ),
                        'type'  => 'select',
                        'options' => array(
                            '2' => array(
                                'label' => esc_html__( 'Two', 'yolo-kidzone' ),
                                'value' => '2',
                            ),
                            '3' => array(
                                'label' => esc_html__( 'Three', 'yolo-kidzone' ),
                                'value' => '3',
                            ),
                        ),
                    ),
                )
            );

            $helper->add_meta_box( $meta_box );

            // Learning Skills
            $meta_box = array(
                'id'        => "{$prefix}_meta_box_learning_skills",
                'title'     => esc_html__( 'Learning Skills', 'yolo-kidzone' ),
                'fields'    => array(
                    array(
                        'id'        => "{$prefix}_learning_skills",
                        'type'      => 'skills',
                        'callback'  =>  array( $this, 'yolo_course_meta_box_callback' )
                    )
                )
            );

            $helper->add_meta_box( $meta_box );

            // Course Quality
            $meta_box = array(
                'id'        => "{$prefix}_meta_box_quality",
                'title'     => esc_html__( 'Course Quality', 'yolo-kidzone' ),
                'fields'    => array(
                    array(
                        'id'        => "{$prefix}_course_quality",
                        'type'      => 'quality',
                        'callback'  =>  array( $this, 'yolo_course_meta_box_quality_callback' )
                    )
                )
            );

            $helper->add_meta_box($meta_box);

            // Course Time
            $meta_box = array(
                'id'        => "{$prefix}_meta_box_course_time",
                'title'     => esc_html__( 'Course Time', 'yolo-kidzone' ),
                'fields'    => array(
                    array(
                        'id'        => "{$prefix}_course_time_table",
                        'label'     => esc_html__( 'Set Time Table', 'yolo-kidzone' ),
                        'type'      => 'course_time',
                        'callback'  =>  array( $this, 'yolo_course_meta_box_class_time_callback' )
                    )
                )
            );

            $helper->add_meta_box($meta_box);

            // Course gallery
            $meta_box = array(
                'id'           => "{$prefix}_gallery",
                'title'        => __( 'Media Data: Gallery', 'yolo-kidzone' ),
                'context'      => 'side',
                'priority'     => 'low',
                'fields'       => array(
                    array(
                        'id' => "{$prefix}_gallery",
                        // 'label' => __( 'Your Portfolio', 'yolo-kidzone' ),
                        'type' => 'gallery',
                    ),
                )
            );

            $helper->add_meta_box( $meta_box, 'dashboard', 'side', 'high' );

            // Page setting - Single Course
            $meta_box = array(
                'id' => "{$prefix}_meta_box_single_page",
                'title' => esc_html__( 'Page Settings: Single Course', 'yolo-kidzone' ),
                'description' => esc_html__( 'Choose various setting for your Single Course page.', 'yolo-kidzone' ),
                'fields' => array(
                    array(
                        'label' => esc_html__( 'Page Layout', 'yolo-kidzone' ),
                        'id' => "{$prefix}_global_setting",
                        'type' => 'page_layout',
                    ),
                    array(
                        'label' => esc_html__( 'Override Global Settings?', 'yolo-kidzone' ),
                        'id' => "{$prefix}_override_layout",
                        'type' => 'checkbox',
                        'child-fields' => array(
                            'on' => "{$prefix}_layout,{$prefix}_sidebar"
                        ),
                    ),
                    array(
                        'label' => esc_html__( 'Page Layout', 'yolo-kidzone' ),
                        'id' => "{$prefix}_layout",
                        'type' => 'radio',
                        'std' => 'sidebar',
                        'options' => array(
                            'fullwidth' => array(
                                'label' => esc_html__( 'Full-Width', 'yolo-kidzone' ),
                                'value' => 'fullwidth',
                            ),
                            'sidebar' => array(
                                'label' => esc_html__( 'With Right Sidebar', 'yolo-kidzone' ),
                                'value' => 'sidebar',
                            ),
                            'left_sidebar' => array(
                                'label' => esc_html__( 'With Left Sidebar', 'yolo-kidzone' ),
                                'value' => 'left_sidebar',
                            ),
                        ),
                        // 'child-fields' => array(
                        //  'sidebar' => "{$prefix}_sidebar",
                        //  'left_sidebar' => "{$prefix}_sidebar",
                        // ),
                        
                    ),
                    array(
                        'label' => esc_html__( 'Course Sidebar', 'yolo-kidzone' ),
                        'id' => "{$prefix}_sidebar",
                        'type' => 'sidebars',
                        'std' => 'sidebar-main'
                    ),
                )
            );

            if( yolo_get_option('yolo_page_heading', true) ) {
                $meta_box['fields'][] = array( 'type' => 'divider' );
                $meta_box['fields'][] = array(
                                    'id'    => '_heading_image',
                                    'label' => esc_html__( 'Heading Background Image', 'yolo-kidzone' ),
                                    'desc'  => esc_html__( 'An unique heading image for this post. If leave it blank, the default heading image of Blog ( in Customizer settings ) will be used.', 'yolo-kidzone'),
                                    'type'  => 'image',
                                );
            }

            $helper->add_meta_box( $meta_box );
        }

        // Learning Skills Functions
        function yolo_course_meta_box_callback( $post, $id, $type, $meta, $std, $field ) {
            ?>
            <div class="yolo-course-skills-meta-box">
                <?php wp_nonce_field( '_yolo_course_learning_skills_meta_box_save', '_yolo_course_learning_skills_meta_box_nonce' ); ?>
                <table class="widefat">
                    <thead>
                    <tr>
                        <th class="sort">&nbsp;</th>
                        <th width="70%" colspan="2"><?php esc_html_e( 'Skills', 'yolo-kidzone' ); ?> </th>
                        <th>&nbsp;</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $skills = yolo_get_post_meta( $post->ID, '_learning_skills', true );

                    if($skills){
                        foreach ( (array)$skills as $key => $skill ) :
                            echo $this->yolo_course_learning_skills_meta_box_row( $key, $skill );
                        endforeach;
                    }
                    ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <th colspan="5">
                            <a href="#" class="button insert" data-row="<?php echo esc_attr($this->yolo_course_learning_skills_meta_box_row( $key='', $skill='' )); ?>"><?php esc_html_e( 'Add Skills', 'yolo-kidzone' ); ?></a>
                        </th>
                    </tr>
                    </tfoot>
                </table>
            </div>
            <?php
        }

        function yolo_course_learning_skills_meta_box_row( $key, $skill ) {
            ob_start();
            ?>
            <tr>
                <td class="sort"></td>
                <td class="file_value">
                    <input type="text" class="input_text" placeholder="<?php esc_html_e( 'Skill Name', 'yolo-kidzone' ); ?>" name="_yolo_learning_skills_name[]" value="<?php if( isset($key) && $key !='' ): echo esc_attr($key); endif; ?>" />
                    <input type="text" class="input_text" placeholder="Duration" name="_yolo_learning_skills_value[]" value="<?php if( isset($skill) && $skill !='' ): echo esc_attr($skill); endif; ?>">
                </td>
                <td width="1%"><a href="#" class="delete"><?php esc_html_e( 'Delete', 'yolo-kidzone' ); ?></a></td>
            </tr>
            <?php
            return ob_get_clean();
        }

        function yolo_course_save_learning_skills_meta_box($post_id, $post){


            if ( defined( 'DOING_AUTOSAVE' ) || is_int( wp_is_post_revision( $post ) ) || is_int( wp_is_post_autosave( $post ) ) ) {
                return;
            }

            if ( ! isset( $_POST['_yolo_course_learning_skills_meta_box_nonce'] ) || ! isset( $_POST['_yolo_course_learning_skills_meta_box_nonce'] ) || ! wp_verify_nonce( $_POST['_yolo_course_learning_skills_meta_box_nonce'], '_yolo_course_learning_skills_meta_box_save' ) )
                return;
            // Check the post being saved == the $post_id to prevent triggering this call for other save_post events
            if ( empty( $_POST['post_ID'] ) || $_POST['post_ID'] != $post_id ) {
                return;
            }
            // Check user has permission to edit
            if ( ! current_user_can( 'edit_post', $post_id ) ) {
                return;
            }

            $skills = array();
            $skills_name           = isset( $_POST['_yolo_learning_skills_name'] )  ? array_map( 'trim', $_POST['_yolo_learning_skills_name'] ) : array();
            $skills_value           = isset( $_POST['_yolo_learning_skills_value'] )  ? array_map( 'trim', $_POST['_yolo_learning_skills_value'] ) : array();
            $skills_value_size       = sizeof( $skills_value );

            for ( $i = 0; $i < $skills_value_size; $i ++ ) {
                if ( ! empty( $skills_value[ $i ] ) ) {
                    $name                   = sanitize_text_field( $skills_name[ $i ] );
                    $value                  = sanitize_text_field( $skills_value[ $i ] );
                    $skills[$name]          = $value;
                }
            }

            update_post_meta( $post_id, '_learning_skills', $skills );
        }

        // Course Quality Functions

        function yolo_course_meta_box_quality_callback( $post, $id, $type, $meta, $std, $field ) {
            ?>
            <div class="yolo-quality-meta-box">
                <?php wp_nonce_field( '_yolo_course_quality_meta_box_save', '_yolo_course_quality_meta_box_nonce' ); ?>
                <table class="widefat">
                    <thead>
                    <tr>
                        <th class="sort">&nbsp;</th>
                        <th width="70%" colspan="2"><?php esc_html_e( 'Quality', 'yolo-kidzone' ); ?> </th>
                        <th>&nbsp;</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $quality = yolo_get_post_meta( $post->ID, '_course_quality', true );

                    if($quality){
                        foreach ( (array)$quality as $key => $quali ) :
                            echo $this->yolo_quality_meta_box_row( $key, $quali );
                        endforeach;
                    }
                    ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <th colspan="5">
                            <a href="#" class="button insert" data-row="<?php echo esc_attr($this->yolo_quality_meta_box_row( $key='', $quali='' )); ?>"><?php esc_html_e( 'Add Quality', 'yolo-kidzone' ); ?></a>
                        </th>
                    </tr>
                    </tfoot>
                </table>
            </div>
            <?php
        }

        function yolo_quality_meta_box_row( $key, $quali ) {
            ob_start();
            // Quality options
            $quality_selector = apply_filters( 'quality_selector', array(
                'excellent'     => __( 'Excellent', 'yolo-kidzone' ),
                'good'          => __( 'Good', 'yolo-kidzone' ),
                'fair'          => __( 'Fair', 'yolo-kidzone' ),
                'poor'          => __( 'Poor', 'yolo-kidzone' )
            ) );
            ?>
            <tr>
                <td class="sort"></td>
                <td class="file_value">
                    <input type="text" class="input_text" placeholder="<?php esc_html_e( 'Quality Name', 'yolo-kidzone' ); ?>" name="_yolo_course_quality_name[]" value="<?php if( isset($key) && $key !='' ): echo esc_attr($key); endif; ?>" />
                    <select id="yolo_course_quality" name="_yolo_course_quality_value[]">
                        <option value=""><?php esc_html_e( 'Select Option', 'yolo-kidzone' ); ?></option>
                        <?php foreach ( $quality_selector as $value => $label ) : ?>
                        <option value="<?php echo esc_attr( $value ); ?>" <?php selected( $quali, $value, true ); ?> ><?php echo esc_html( $label ); ?></option>';
                        <?php endforeach; ?>
                   </select>
                </td>
                <td width="1%"><a href="#" class="delete"><?php esc_html_e( 'Delete', 'yolo-kidzone' ); ?></a></td>
            </tr>
            <?php
            return ob_get_clean();
        }

        function yolo_course_save_quality_meta_box($post_id, $post){


            if ( defined( 'DOING_AUTOSAVE' ) || is_int( wp_is_post_revision( $post ) ) || is_int( wp_is_post_autosave( $post ) ) ) {
                return;
            }

            if ( ! isset( $_POST['_yolo_course_quality_meta_box_nonce'] ) || ! isset( $_POST['_yolo_course_quality_meta_box_nonce'] ) || ! wp_verify_nonce( $_POST['_yolo_course_quality_meta_box_nonce'], '_yolo_course_quality_meta_box_save' ) )
                return;
            // Check the post being saved == the $post_id to prevent triggering this call for other save_post events
            if ( empty( $_POST['post_ID'] ) || $_POST['post_ID'] != $post_id ) {
                return;
            }
            // Check user has permission to edit
            if ( ! current_user_can( 'edit_post', $post_id ) ) {
                return;
            }

            $quality = array();
            $quality_name           = isset( $_POST['_yolo_course_quality_name'] )  ? array_map( 'trim', $_POST['_yolo_course_quality_name'] ) : array();
            $quality_value           = isset( $_POST['_yolo_course_quality_value'] )  ? array_map( 'trim', $_POST['_yolo_course_quality_value'] ) : array();
            $quality_value_size       = sizeof( $quality_value );

            for ( $i = 0; $i < $quality_value_size; $i ++ ) {
                if ( ! empty( $quality_value[ $i ] ) ) {
                    $name                   = sanitize_text_field( $quality_name[ $i ] );
                    $value                  = sanitize_text_field( $quality_value[ $i ] );
                    $quality[$name]          = $value;
                }
            }

            update_post_meta( $post_id, '_course_quality', $quality );
        }

        // Course Teacher Functions
        function yolo_course_meta_box_course_teacher_callback( $post, $id, $type, $meta, $std, $field ) {
            $post_teacher = $this->yolo_get_posts_post_type( 'teacher' );
            $course_teacher = yolo_get_post_meta( $post->ID, '_course_teacher', true );
        ?>
            <select id="yolo_course_teacher" name="_yolo_course_teacher_id">
                    <option value=""><?php esc_html_e( 'Select Teacher', 'yolo-kidzone' ); ?></option>
            <?php if( $post_teacher->have_posts() ) : 
                while( $post_teacher->have_posts() ) :
                    $post_teacher->the_post();
                ?>
                    <option value="<?php the_ID(); ?>" class="<?php echo $course_teacher;  ?>" <?php selected( get_the_ID(), $course_teacher, true ); ?> ><?php echo esc_html( the_title() ); ?></option>';
            <?php 
                endwhile;
            endif;
            ?>
            </select>
        <?php }

        function yolo_get_posts_post_type( $type ) {
            $yolo_args = array(
                'post_type'     => $type,
                'posts_per_page'=> '9999', // @TODO: How to show all teacher
                'post_status'   => 'publish'
            );
            $yolo_query = new WP_Query( $yolo_args );

            return $yolo_query;
        }

        function yolo_course_save_course_teacher_meta_box( $post_id, $post ) {

            if ( defined( 'DOING_AUTOSAVE' ) || is_int( wp_is_post_revision( $post ) ) || is_int( wp_is_post_autosave( $post ) ) ) {
                return;
            }

            // Check the post being saved == the $post_id to prevent triggering this call for other save_post events
            if ( empty( $_POST['post_ID'] ) || $_POST['post_ID'] != $post_id ) {
                return;
            }
            // Check user has permission to edit
            if ( ! current_user_can( 'edit_post', $post_id ) ) {
                return;
            }



            // Update only if post type is course - all other post type run over here (???)
            if ( get_post_type( $post ) == 'course' ) {
                $teacher_id = sanitize_text_field( $_POST['_yolo_course_teacher_id'] );
                update_post_meta( $post_id, '_course_teacher', $teacher_id );
            }
        }

        // Course Testimonials functions
        function yolo_course_testimonials_meta_box_callback( $post, $id, $type, $meta, $std, $field ) {
            $post_testimonials = $this->yolo_get_posts_post_type( 'testimonial' );
            $course_testimonials = yolo_get_post_meta( $post->ID, '_course_testimonials', false );
           
        ?>
            <select id="yolo_course_testimonials" name="_yolo_course_testimonials_id[]" data-placeholder="<?php esc_html_e( 'Select Testimonials(Defautl: ALL)', 'yolo-kidzone' ); ?>" style="width: 300px;" multiple class="chosen-select">
            <?php if( $post_testimonials->have_posts() ) : 
                while( $post_testimonials->have_posts() ) :
                    $post_testimonials->the_post();

                ?>
                    <option value="<?php the_ID(); ?>" class="course-testimonials" 
                        <?php
                            if($course_testimonials) : 
                                foreach( $course_testimonials as $testimonial ) :
                                    selected( get_the_ID(), $testimonial, true );
                                endforeach;
                            endif; 
                        ?> 
                    > <!-- end option -->
                        <?php echo esc_html( the_title() ); ?>
                    </option>';
            <?php 
                endwhile;
            endif;
            ?>
            </select>
        <?php }

        function yolo_course_save_testimonials_meta_box( $post_id, $post ) {

            if ( defined( 'DOING_AUTOSAVE' ) || is_int( wp_is_post_revision( $post ) ) || is_int( wp_is_post_autosave( $post ) ) ) {
                return;
            }

            // Check the post being saved == the $post_id to prevent triggering this call for other save_post events
            if ( empty( $_POST['post_ID'] ) || $_POST['post_ID'] != $post_id ) {
                return;
            }
            // Check user has permission to edit
            if ( ! current_user_can( 'edit_post', $post_id ) ) {
                return;
            }

            $testimonials           = isset( $_POST['_yolo_course_testimonials_id'] )  ? array_map( 'trim', $_POST['_yolo_course_testimonials_id'] ) : array();

            // Update only if post type is event - all other post type run over here (generate metabox cause this in $_POST)
            if ( get_post_type( $post ) == 'course' ) {
                update_post_meta( $post_id, '_course_testimonials', $testimonials );
            }
        }

        // Course Time Fuctions (check name of input carefully and wp_nonce carefully)
        function yolo_course_meta_box_class_time_callback( $post, $id, $type, $meta, $std, $field ) { 
            wp_enqueue_script( 'vendor-datetimepicker' );
            wp_enqueue_style( 'vendor-datetimepicker' );
            $mon = esc_html__('monday', 'yolo-kidzone');
            $tue = esc_html__('tuesday', 'yolo-kidzone');
            $wed = esc_html__('wednesday', 'yolo-kidzone');
            $thur = esc_html__('thursday', 'yolo-kidzone');
            $fri = esc_html__('friday', 'yolo-kidzone');
            $sat = esc_html__('saturday', 'yolo-kidzone');
            $sun = esc_html__('sunday', 'yolo-kidzone');
            $week_days = array( $mon, $tue, $wed, $thur, $fri, $sat, $sun );
            $c_times = yolo_get_post_meta( $post->ID, '_course_class_time', true );
        ?>
            <?php wp_nonce_field( '_yolo_course_time_meta_box_save', '_yolo_course_time_meta_box_nonce' ); ?>
            <div>
                <?php foreach( $week_days as $week_day ) : ?>

                <div class="yolo-weekday">
                    <label><strong><?php _e( ucfirst($week_day), 'yolo-kidzone' ); ?></strong></label>
                    <input type="text" class="input_text yolo-time" placeholder="<?php esc_html_e( 'Start Time', 'yolo-kidzone' ); ?>" id="<?php echo $week_day; ?>_start" name="<?php echo $week_day; ?>_start" value="<?php if( isset($c_times[$week_day]) ) : echo $c_times[$week_day]['start']; endif; ?>">
                    <input type="text" class="input_text yolo-time" placeholder="<?php esc_html_e( 'End Time', 'yolo-kidzone' ); ?>" id="<?php echo $week_day; ?>_end" name="<?php echo $week_day; ?>_end" value="<?php if( isset($c_times[$week_day]) ) : echo $c_times[$week_day]['end']; endif; ?>">
                </div>
                <?php endforeach; ?>
            </div>
            <script type="text/javascript">
                jQuery(document).ready(function($) {
                    <?php foreach( $week_days as $week_day ) : ?>
                    $('#<?php echo $week_day . "_start"; ?>, #<?php echo $week_day . "_end"; ?>').datetimepicker( {
                            datepicker:false,
                            format:'H:i',
                            step:15
                    } );
                    <?php endforeach; ?>
                } );
            </script>
        <?php }

        function yolo_course_save_class_time_meta_box( $post_id, $post ) {
            if ( defined( 'DOING_AUTOSAVE' ) || is_int( wp_is_post_revision( $post ) ) || is_int( wp_is_post_autosave( $post ) ) ) {
                return;
            }
            if ( ! isset( $_POST['_yolo_course_time_meta_box_nonce'] ) || ! isset( $_POST['_yolo_course_time_meta_box_nonce'] ) || ! wp_verify_nonce( $_POST['_yolo_course_time_meta_box_nonce'], '_yolo_course_time_meta_box_save' ) )
                return;

            // Check the post being saved == the $post_id to prevent triggering this call for other save_post events
            if ( empty( $_POST['post_ID'] ) || $_POST['post_ID'] != $post_id ) {
                return;
            }
            // Check user has permission to edit
            if ( ! current_user_can( 'edit_post', $post_id ) ) {
                return;
            }

            $mon = esc_html__('monday', 'yolo-kidzone');
            $tue = esc_html__('tuesday', 'yolo-kidzone');
            $wed = esc_html__('wednesday', 'yolo-kidzone');
            $thur = esc_html__('thursday', 'yolo-kidzone');
            $fri = esc_html__('friday', 'yolo-kidzone');
            $sat = esc_html__('saturday', 'yolo-kidzone');
            $sun = esc_html__('sunday', 'yolo-kidzone');
            $week_days = array( $mon, $tue, $wed, $thur, $fri, $sat, $sun );
            $class_time = array();
            foreach( $week_days as $week_day ) {
                $class_time_start[$week_day]            = $_POST[$week_day.'_start'];
                $class_time_end[$week_day]              = $_POST[$week_day.'_end'];
                $class_time[$week_day]                  = array(
                    'start'     =>  $class_time_start[$week_day],
                    'end'       =>  $class_time_end[$week_day]
                );
            }

            update_post_meta( $post_id, '_course_class_time', $class_time );
        }
    }
    new Yolo_Course();
endif;









