<?php
/**
 * Yolo Post Type functions to add, remove meta boxes, add/remove columns display at back-end
 *
 * @package    YOLO Framework
 * @subpackage YOLO Post type
 * @version    1.0.0
 * @author     GDragon <longdt@yolotheme.com>
 * @copyright  Copyright (c) 2015, YoloTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://yolotheme.com
 */


if(!class_exists('Yolo_CPT')):
	class Yolo_CPT {

		public function __construct() {

			add_image_size('portfolio-small',120,120,true);

			if( is_admin() ) {
			 	add_filter('manage_edit-portfolio_columns', array( &$this, 'yolo_add_portfolio_thumbnail_column') );
        		add_action('manage_posts_custom_column', array( &$this, 'yolo_display_portfolio_thumbnail_column') );
			}
		}


		// Add Thumbnail Column to the Gallery Admin page
        public function yolo_add_portfolio_thumbnail_column($columns) {
            $before = array_slice($columns, 0, 1);
            $after = array_slice($columns, 1);
            
            $thumbnail_column = array(
                'thumbnail' => esc_html__('Thumbnail', 'yolo-kidzone')
            );
            
            $columns = array_merge($before, $thumbnail_column, $after);
            return $columns;
        }

        public function yolo_display_portfolio_thumbnail_column($column) {
            GLOBAL $post;
            
            if ($column == 'thumbnail') {
                $prefix = '_yolo_wp_post';
                $admin_thumb = 'portfolio-small';
                $post_id = get_the_ID();
                $post_format = yolo_get_post_meta($post_id, "{$prefix}_media_type", 'image');
                $thumb = '';

                switch ($post_format) {
                    case 'image':
                        $main_image = yolo_get_post_meta($post_id, "{$prefix}_main_image", 'featured');
                        if( $main_image == 'featured') {
                            $thumb = get_the_post_thumbnail($post_id, $admin_thumb);
                        } else {
                            $image_id = (int) yolo_get_post_meta($post_id, "{$prefix}_image", '');
                            $thumb = !empty($image_id) ? wp_get_attachment_image( $image_id, $admin_thumb) : '';
                        }

                        break;
                    case 'link':
                        $link = yolo_get_post_meta($post_id, "{$prefix}_url", '#');
                        $thumb = get_the_post_thumbnail($post_id, $admin_thumb);
                        break;
                    case 'gallery':
                        $gallery_ids = yolo_get_post_meta($post_id, "{$prefix}_gallery", '');
                        if(!empty($gallery_ids)) {
                            $gallery_arr = explode(',', $gallery_ids);
                            $image_id = (int) $gallery_arr[0];
                            $thumb = !empty($image_id) ? wp_get_attachment_image( $image_id, $admin_thumb) : '';
                        }

                        break;
                    default:
                        $thumb = get_the_post_thumbnail($post_id, $admin_thumb);
                        break;
                }

                echo '<a href="' . get_edit_post_link() . '">' . $thumb . '</a>';
            }
        }
        
	}
endif;