<?php
/**
 * Register YOLO Portfolio.
 * This file register Item and Category for YOLO Portfolio.
 *
 * @package    YOLO Framework
 * @subpackage YOLO Portfolio
 * @version    1.0.0
 * @author     GDragon <longdt@yolotheme.com>
 * @copyright  Copyright (c) 2015, YoloTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://yolotheme.com
 */

if( !class_exists('Yolo_Portfolio') ):
    if( !class_exists('Yolo_CPT') ) {
        require_once dirname(__FILE__) . '/yolo-cpt.php';
    }

    class Yolo_Portfolio {

        public function __construct(){
            add_action( 'init', array($this, 'yolo_portfolio_register_post_type' ));
            add_action ( 'admin_enqueue_scripts', array( &$this,'yolo_admin_enqueue_scripts' ));

            if( is_admin() ){
                add_action('add_meta_boxes', array($this,'yolo_portfolio_register_meta_box'));
            }
        }

        public function yolo_admin_enqueue_scripts(){
            wp_register_style( 'yolo-style-admin', YOLO_PLUGIN_PATH . '/assets/css/yolo-admin.css' );
            wp_enqueue_style( 'yolo-style-admin' );
            wp_enqueue_script('yolo-properties-admin', YOLO_PLUGIN_PATH . '/assets/js/properties.js', array('jquery'), null, true );

        }

        public function yolo_portfolio_register_post_type() {

            // Text for YOLO Portfolio.
            $portfolio_labels = array(
                'name'                  => __('Portfolio', 'yolo-kidzone') ,
                'singular_name'         => __('Portfolio', 'yolo-kidzone') ,
                'menu_name'             => __('Portfolio', 'yolo-kidzone') ,
                'add_new'               => __('Add New', 'yolo-kidzone') ,
                'add_new_item'          => __('Add New Portfolio Item', 'yolo-kidzone') ,
                'edit_item'             => __('Edit Portfolio Item', 'yolo-kidzone') ,
                'new_item'              => __('Add New Portfolio Item', 'yolo-kidzone') ,
                'view_item'             => __('View Portfolio', 'yolo-kidzone') ,
                'search_items'          => __('Search Portfolio', 'yolo-kidzone') ,
                'not_found'             => __('No Portfolio items found', 'yolo-kidzone') ,
                'not_found_in_trash'    => __('No Portfolio items found in trash', 'yolo-kidzone') ,
                'parent_item_colon'     => ''
            );

            $admin_icon = YOLO_PLUGIN_PATH . '/assets/images/yolo20x20.png';
            if ( floatval( get_bloginfo( 'version' ) ) >= 3.8 ) {
                $admin_icon = 'dashicons-media-document';
            }

            $portfolio_slug = 'yolo-portfolio';

            // Options
            $portfolio_args = array(
                'labels'                => $portfolio_labels,
                'public'                => false,
                'publicly_queryable'    => true,
                'show_ui'               => true,
                'show_in_nav_menus'     => true,
                'show_in_menu'          => true,
                'menu_position'         => 5,
                'menu_icon'             => $admin_icon,
                'capability_type'       => 'post',
                'hierarchical'          => false,
                'supports'              => array(
                    'title',
                    // 'editor',
                    'thumbnail',
                    // 'excerpt',
                    'comments',
                    'revisions'
                ) ,
                'has_archive'           => true,
                'rewrite'               => array(
                    'slug'          => $portfolio_slug,
                    'with_front'    => false
                )
            );

            register_post_type( 'portfolio', $portfolio_args );

            // Register a taxonomy for Portfolio Categories.
            $category_labels = array(
                'name'                          => __('Portfolio Categories', 'yolo-kidzone') ,
                'singular_name'                 => __('Portfolio Category', 'yolo-kidzone') ,
                'menu_name'                     => __('Portfolio Categories', 'yolo-kidzone') ,
                'all_items'                     => __('All Portfolio Categories', 'yolo-kidzone') ,
                'edit_item'                     => __('Edit Portfolio Category', 'yolo-kidzone') ,
                'view_item'                     => __('View Portfolio Category', 'yolo-kidzone') ,
                'update_item'                   => __('Update Portfolio Category', 'yolo-kidzone') ,
                'add_new_item'                  => __('Add New Portfolio Category', 'yolo-kidzone') ,
                'new_item_name'                 => __('New Portfolio Category Name', 'yolo-kidzone') ,
                'parent_item'                   => __('Parent Portfolio Category', 'yolo-kidzone') ,
                'parent_item_colon'             => __('Parent Portfolio Category:', 'yolo-kidzone') ,
                'search_items'                  => __('Search Portfolio Categories', 'yolo-kidzone') ,
                'popular_items'                 => __('Popular Portfolio Categories', 'yolo-kidzone') ,
                'separate_items_with_commas'    => __('Separate Portfolio Categories with commas', 'yolo-kidzone') ,
                'add_or_remove_items'           => __('Add or remove Portfolio Categories', 'yolo-kidzone') ,
                'choose_from_most_used'         => __('Choose from the most used Portfolio Categories', 'yolo-kidzone') ,
                'not_found'                     => __('No Portfolio Categories found', 'yolo-kidzone') ,
            );

            $category_args = array(
                'labels'                        => $category_labels,
                'public'                        => false,
                'show_ui'                       => true,
                'show_tagcloud'                 => false,
                'show_admin_column'             => true,
                'hierarchical'                  => true,
                'query_var'                     => true,
                'rewrite'                       => array(
                    'slug'          => 'portfolio_category',
                    'with_front'    => false
                ) ,
            );

            register_taxonomy( 'portfolio_category', array(
                'portfolio'
            ) , $category_args);
        }

        public function yolo_portfolio_register_meta_box() {

            // Remove Meta box
            // remove_meta_box( 'mymetabox_revslider_0', 'portfolio', 'normal' );

            // Declare helper object
            $prefix = '_yolo_wp_portfolio';
            $helper = new YOLO_Meta_Boxes_Helper($prefix, array(
                'page' => 'portfolio'
            ));
            
            // Media_type
            $meta_box = array(
                'id'           => "{$prefix}_meta_box_media_type",
                'title'        => __( 'Media Type', 'yolo-kidzone' ),
                // 'context'      => 'side',
                'priority'     => 'high',
                'description'  => __( 'Choose the media type for this Portfolio Item.', 'yolo-kidzone' ),
                'fields'       => array(
                    array(
                        'id'  => "{$prefix}_media_type",
                        'type'  => 'radio',
                        'std'   => 'image',
                        'class'  => 'yolo-post-type',
                        'options' => array(
                            'image' => array(
                                'label' => __( 'Image', 'yolo-kidzone' ),
                                'value' => 'image',
                                'class' => 'post-format-icon post-format-image',
                            ),
                            'link' => array(
                                'label' => __( 'Link', 'yolo-kidzone' ),
                                'value' => 'link',
                                'class' => 'post-format-icon post-format-link',
                            ),
                            'gallery' => array(
                                'label' => __( 'Gallery', 'yolo-kidzone' ),
                                'value' => 'gallery',
                                'class' => 'post-format-icon post-format-gallery',
                            ),
                            'video' => array(
                                'label' => __( 'Video', 'yolo-kidzone' ),
                                'value' => 'video',
                                'class' => 'post-format-icon post-format-video',
                            ),
                        ),
                        // Childboxes added in general metabox
                        'child-boxes' => array(
                            // 'image' => "{$prefix}_meta_box_image",
                            'link' => "{$prefix}_meta_box_link",
                            'gallery' => "{$prefix}_meta_box_gallery",
                            'video' => "{$prefix}_meta_box_video",
                        )
                    )
                ),
            );

            $helper->add_meta_box( $meta_box );

            // Data type: Link
            $meta_box = array(
                'id'           => "{$prefix}_meta_box_link",
                'title'        => __( 'Media Data: Link', 'yolo-kidzone' ),
                'fields'       => array(
                    array(
                        'id' => "{$prefix}_project_url", // @TODO: should change to portfolio_url and change
                        'label' => __( 'Project URL', 'yolo-kidzone' ),
                        'desc' => __( 'Insert URL of portfolio here.', 'yolo-kidzone' ),
                        'type' => 'text',
                    )
                )
            );

            $helper->add_meta_box( $meta_box );

            // Data type: Video
            $meta_box = array(
                'id'           => "{$prefix}_meta_box_video",
                'title'        => __( 'Media Data: Video', 'yolo-kidzone' ),
                'fields'       => array(
                    // array(
                    //  'id' => "{$prefix}_video_m4v",
                    //  'label' => __( 'M4V File URL', 'yolo-kidzone' ),
                    //  'desc' => __( 'Place the URL to your .m4v video file here.', 'yolo-kidzone' ),
                    //  'type' => 'text',
                    // ),
                    // array(
                    //  'id' => "{$prefix}_video_ogv",
                    //  'label' => __( 'OGV File URL', 'yolo-kidzone' ),
                    //  'desc' => __( 'Place the URL to your .ogv video file here.', 'yolo-kidzone' ),
                    //  'type' => 'text',
                    // ),
                    array(
                        'id' => "{$prefix}_video_embed",
                        'label' => __( 'Embedded Video Code', 'yolo-kidzone' ),
                        'desc' => __( 'If you are using videos from online sharing sites (YouTube, Vimeo, etc.) paste the embedded code here. This field will override above settings.', 'yolo-kidzone' ),
                        'type' => 'textarea',
                        'std'  => ''
                    ),
                    array(
                        'id' => "{$prefix}_video_aspect_ratio",
                        'label'    => __( 'Video Aspect Ratio', 'yolo-kidzone' ),
                        'desc'    => __( 'Choose the aspect ratio for your video.', 'yolo-kidzone' ),
                        'type'    => 'select',
                        'std'     => '16:9',
                        'options' => array(
                            array('value'=>'16:9','label'=>'16:9'),
                            array('value'=>'5:3','label'=>'5:3'),
                            array('value'=>'5:4','label'=>'5:4'),
                            array('value'=>'4:3','label'=>'4:3'),
                            array('value'=>'3:2','label'=>'3:2')
                        )
                    )
                )
            );

            $helper->add_meta_box( $meta_box );

            // Data type: Portfolio
            $meta_box = array(
                'id'           => "{$prefix}_meta_box_gallery",
                'title'        => __( 'Media Data: Gallery', 'yolo-kidzone' ),
                'fields'       => array(
                    array(
                        'id' => "{$prefix}_gallery",
                        // 'label' => __( 'Your Portfolio', 'yolo-kidzone' ),
                        'type' => 'gallery',
                    ),
                )
            );

            $helper->add_meta_box( $meta_box );

        }

    }

    new Yolo_Portfolio();

    new Yolo_CPT();

endif;









