<?php
/**
 * Register YOLO Teacher.
 * This file register Item and Category for YOLO Teacher.
 *
 * @package    YOLO Framework
 * @subpackage YOLO Teacher
 * @version    1.0.0
 * @author     GDragon <longdt@yolotheme.com>
 * @copyright  Copyright (c) 2015, YoloTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://yolotheme.com
 */

if( !class_exists('Yolo_Teacher') ):

    class Yolo_Teacher {

        public function __construct(){
            add_action( 'init', array($this, 'yolo_teacher_register_post_type' ));
            add_action( 'save_post', array( &$this, 'yolo_teacher_save_skills_meta_box'), 1, 2 );
            add_action( 'save_post', array( &$this, 'yolo_teacher_save_performance_meta_box'), 1, 2 );
            add_action( 'save_post', array( &$this, 'yolo_teacher_save_testimonials_meta_box'), 1, 2 );
            add_action( 'save_post', array( &$this, 'yolo_teacher_save_teacher_contact_meta_box'), 1, 2 );
            add_action ( 'admin_enqueue_scripts', array( &$this,'yolo_admin_enqueue_scripts' ));
            if( is_admin() ){
                add_action('add_meta_boxes', array($this,'yolo_teacher_register_meta_box'));
            }
        }

        public function yolo_admin_enqueue_scripts(){
            wp_register_style( 'yolo-style-admin', YOLO_PLUGIN_PATH . '/assets/css/yolo-admin.css' );
            wp_register_style( 'vendor-chosen-css', YOLO_FRAMEWORK_URI . '/assets/css/yolo-chosen.css', null, null, 'all' );
            wp_enqueue_style( 'vendor-chosen-css' );
            wp_enqueue_style( 'yolo-style-admin' );
            wp_enqueue_script( 'vendor-chosen-js' );
            wp_enqueue_script('yolo-properties-admin', YOLO_PLUGIN_PATH . '/assets/js/properties.js', array('jquery'), null, true );

        }

        public function yolo_teacher_register_post_type() {

            // Text for YOLO Teacher.
            $teacher_labels = array(
                'name'                  => esc_html__( 'Teachers', 'yolo-kidzone' ) ,
                'singular_name'         => esc_html__( 'Teachers', 'yolo-kidzone' ) ,
                'menu_name'             => esc_html__( 'Teachers', 'yolo-kidzone' ) ,
                'add_new'               => esc_html__( 'Add New', 'yolo-kidzone' ) ,
                'add_new_item'          => esc_html__( 'Add New Teacher Item', 'yolo-kidzone' ) ,
                'edit_item'             => esc_html__( 'Edit Teacher Item', 'yolo-kidzone' ) ,
                'new_item'              => esc_html__( 'Add New Teacher Item', 'yolo-kidzone' ) ,
                'view_item'             => esc_html__( 'View Teacher', 'yolo-kidzone' ) ,
                'search_items'          => esc_html__( 'Search Teacher', 'yolo-kidzone' ) ,
                'not_found'             => esc_html__( 'No Teacher items found', 'yolo-kidzone' ) ,
                'not_found_in_trash'    => esc_html__( 'No Teacher items found in trash', 'yolo-kidzone' ) ,
                'parent_item_colon'     => ''
            );

            $admin_icon = YOLO_PLUGIN_PATH . '/assets/images/yolo20x20.png';
            if ( floatval( get_bloginfo( 'version' ) ) >= 3.8 ) {
                $admin_icon = 'dashicons-businessman';
            }

            $teacher_slug = 'yolo-teacher';

            // Options
            $teacher_args = array(
                'labels'                => $teacher_labels,
                'public'                => true, // Use this to see teacher front-end by taxonomy
                'publicly_queryable'    => true,
                'show_ui'               => true,
                'show_in_nav_menus'     => true,
                'show_in_menu'          => true,
                'menu_position'         => 5,
                'menu_icon'             => $admin_icon,
                'capability_type'       => 'post',
                'hierarchical'          => false,
                'supports'              => array(
                    'title',
                    'editor',
                    'excerpt',
                    'thumbnail',
                    'comments',
                    'revisions'
                ) ,
                'has_archive'           => true,
                'rewrite'               => array(
                    'slug'          => $teacher_slug,
                    'with_front'    => false
                )
            );

            register_post_type( 'teacher', $teacher_args );

            // Register a taxonomy for Teacher Categories.
            $category_labels = array(
                'name'                          => esc_html__( 'Teacher Categories', 'yolo-kidzone' ) ,
                'singular_name'                 => esc_html__( 'Teacher Category', 'yolo-kidzone') ,
                'menu_name'                     => esc_html__( 'Teacher Categories', 'yolo-kidzone' ) ,
                'all_items'                     => esc_html__( 'All Teacher Categories', 'yolo-kidzone' ) ,
                'edit_item'                     => esc_html__( 'Edit Teacher Category', 'yolo-kidzone' ) ,
                'view_item'                     => esc_html__( 'View Teacher Category', 'yolo-kidzone' ) ,
                'update_item'                   => esc_html__( 'Update Teacher Category', 'yolo-kidzone' ) ,
                'add_new_item'                  => esc_html__( 'Add New Teacher Category', 'yolo-kidzone' ) ,
                'new_item_name'                 => esc_html__( 'New Teacher Category Name', 'yolo-kidzone' ) ,
                'parent_item'                   => esc_html__( 'Parent Teacher Category', 'yolo-kidzone' ) ,
                'parent_item_colon'             => esc_html__( 'Parent Teacher Category:', 'yolo-kidzone' ) ,
                'search_items'                  => esc_html__( 'Search Teacher Categories', 'yolo-kidzone' ) ,
                'popular_items'                 => esc_html__( 'Popular Teacher Categories', 'yolo-kidzone' ) ,
                'separate_items_with_commas'    => esc_html__( 'Separate Teacher Categories with commas', 'yolo-kidzone' ) ,
                'add_or_remove_items'           => esc_html__( 'Add or remove Teacher Categories', 'yolo-kidzone' ) ,
                'choose_from_most_used'         => esc_html__( 'Choose from the most used Teacher Categories', 'yolo-kidzone' ) ,
                'not_found'                     => esc_html__( 'No Teacher Categories found', 'yolo-kidzone' ) ,
            );

            $category_args = array(
                'labels'                        => $category_labels,
                'public'                        => true,
                'show_ui'                       => true,
                'show_in_nav_menus'             => false,
                'show_tagcloud'                 => false,
                'show_admin_column'             => true,
                'hierarchical'                  => true,
                'query_var'                     => true,
                'rewrite'                       => array(
                    'slug'          => 'teacher_category',
                    'with_front'    => false
                ) ,
            );

            register_taxonomy( 'teacher_category', array( 'teacher' ) , $category_args);
        }

        public function yolo_teacher_register_meta_box(){
            // Declare helper object
            $prefix = '_yolo_wp_post';
            $helper = new YOLO_Meta_Boxes_Helper($prefix, array(
                'page' => 'teacher'
            ));
            // Information fields
            $meta_box = array(
                'id'                => "{$prefix}_meta_box_teacher",
                'title'             => esc_html__( 'Teacher options', 'yolo-kidzone' ),
                'fields'            => array(
                    array(
                        'id'    => "{$prefix}_name",
                        'label' => esc_html__( 'Teacher Name', 'yolo-kidzone' ),
                        'type'  => 'text',
                    ),
                    array(
                        'id'    => "{$prefix}_position",
                        'label' => esc_html__( 'Teacher Position', 'yolo-kidzone' ),
                        'type'  => 'text',
                    ),
                    array(
                        'id'    => "{$prefix}_phone",
                        'label' => esc_html__( 'Teacher Phone', 'yolo-kidzone' ),
                        'type'  => 'text',
                    ),
                    array(
                        'id'    => "{$prefix}_email",
                        'label' => esc_html__( 'Teacher Email', 'yolo-kidzone' ),
                        'type'  => 'text',
                    ),
                    array(
                        'id'    => "{$prefix}_twitter",
                        'label' => esc_html__( 'Social Twitter', 'yolo-kidzone' ),
                        'type'  => 'text',
                    ),
                    array(
                        'id'    => "{$prefix}_facebook",
                        'label' => esc_html__( 'Social Facebook', 'yolo-kidzone' ),
                        'type'  => 'text',
                    ),
                    array(
                        'id'    => "{$prefix}_googleplus",
                        'label' => esc_html__( 'Social GooglePlus', 'yolo-kidzone' ),
                        'type'  => 'text',
                    ),
                    array(
                        'id'    => "{$prefix}_linkedin",
                        'label' => esc_html__( 'Social LinkedIn', 'yolo-kidzone' ),
                        'type'  => 'text',
                    ),
                    array(
                        'id'    => "{$prefix}_pinterest",
                        'label' => esc_html__( 'Social Pinterest', 'yolo-kidzone' ),
                        'type'  => 'text',
                    ),
                    array(
                        'id'    => "{$prefix}_instagram",
                        'label' => esc_html__( 'Social Instagram', 'yolo-kidzone' ),
                        'type'  => 'text',
                    ),
                )
            );

            $helper->add_meta_box( $meta_box );

            // Teacher Testimonials
            $meta_box = array(
                'id'        => "{$prefix}_teacher_meta_box_testimonials",
                'title'     => esc_html__( 'Teacher Testimonials', 'yolo-kidzone' ),
                'fields'    => array(
                    array(
                        'id'        => "{$prefix}_teacher_testimonials",
                        'type'      => 'testimonials',
                        'label'     => esc_html__( 'Select Testimonials', 'yolo-kidzone' ),
                        'callback'  =>  array( $this,'yolo_teacher_testimonials_meta_box_callback' )
                    ),
                    array(
                        'id'    => "{$prefix}_testimonial_columns",
                        'label' => esc_html__( 'Testimonial Columns', 'yolo-kidzone' ),
                        'type'  => 'select',
                        'options' => array(
                            '2' => array(
                                'label' => esc_html__( 'Two', 'yolo-kidzone' ),
                                'value' => '2',
                            ),
                            '3' => array(
                                'label' => esc_html__( 'Three', 'yolo-kidzone' ),
                                'value' => '3',
                            ),
                        ),
                    ),
                ),
                
            );

            $helper->add_meta_box( $meta_box );

            // Teacher Contact Form
            $meta_box = array(
                'id'        => "{$prefix}_meta_box_teacher_contact",
                'title'     => esc_html__( 'Teacher Contact Form', 'yolo-kidzone' ),
                'fields'    => array(
                    array(
                        'id'        => "{$prefix}_teacher_contact",
                        'type'      => 'contact',
                        'label'     => esc_html__( 'Select Contact Form', 'yolo-kidzone' ),
                        'callback'  =>  array( $this,'yolo_teacher_contact_meta_box_callback' )
                    )
                )
            );

            $helper->add_meta_box( $meta_box );

            // Teaching Skills
            $meta_box = array(
                'id'        => "{$prefix}_teacher_meta_box_skills",
                'title'     => esc_html__( 'Teaching Skills', 'yolo-kidzone' ),
                'fields'    => array(
                    array(
                        'id'        => "{$prefix}_teacher_skills",
                        'type'      => 'skills',
                        'callback'  =>  array($this,'yolo_teacher_meta_box_skills_callback')
                    )
                )
            );

            $helper->add_meta_box( $meta_box );

            // Teacher Performance
            $meta_box = array(
                'id'        => "{$prefix}_teacher_meta_box_performance",
                'title'     => esc_html__( 'Teacher Performance', 'yolo-kidzone' ),
                'fields'    => array(
                    array(
                        'id'        => "{$prefix}_teacher_performance",
                        'type'      => 'performance',
                        'callback'  =>  array( $this,'yolo_teacher_meta_box_performance_callback' )
                    )
                )
            );

            $helper->add_meta_box($meta_box);

            // Page setting - Single Teacher
            $meta_box = array(
                'id' => "{$prefix}_meta_box_single_page",
                'title' => esc_html__( 'Page Settings: Single Teacher', 'yolo-kidzone' ),
                'description' => esc_html__( 'Choose various setting for your Single Teacher page.', 'yolo-kidzone' ),
                'fields' => array(
                    array(
                        'label' => esc_html__( 'Page Layout', 'yolo-kidzone' ),
                        'id' => "{$prefix}_global_setting",
                        'type' => 'page_layout',
                    ),
                    array(
                        'label' => esc_html__( 'Override Global Settings?', 'yolo-kidzone' ),
                        'id' => "{$prefix}_override_layout",
                        'type' => 'checkbox',
                        'child-fields' => array(
                            'on' => "{$prefix}_layout,{$prefix}_sidebar"
                        ),
                    ),
                    array(
                        'label' => esc_html__( 'Page Layout', 'yolo-kidzone' ),
                        'id' => "{$prefix}_layout",
                        'type' => 'radio',
                        'std' => 'sidebar',
                        'options' => array(
                            'fullwidth' => array(
                                'label' => esc_html__( 'Full-Width', 'yolo-kidzone' ),
                                'value' => 'fullwidth',
                            ),
                            'sidebar' => array(
                                'label' => esc_html__( 'With Right Sidebar', 'yolo-kidzone' ),
                                'value' => 'sidebar',
                            ),
                            'left_sidebar' => array(
                                'label' => esc_html__( 'With Left Sidebar', 'yolo-kidzone' ),
                                'value' => 'left_sidebar',
                            ),
                        ),
                        // 'child-fields' => array(
                        //  'sidebar' => "{$prefix}_sidebar",
                        //  'left_sidebar' => "{$prefix}_sidebar",
                        // ),
                        
                    ),
                    array(
                        'label' => esc_html__( 'Teacher Sidebar', 'yolo-kidzone' ),
                        'id' => "{$prefix}_sidebar",
                        'type' => 'sidebars',
                        'std' => 'sidebar-main'
                    ),
                )
            );

            if( yolo_get_option('yolo_page_heading', true) ) {
                $meta_box['fields'][] = array( 'type' => 'divider' );
                $meta_box['fields'][] = array(
                                    'id'    => '_heading_image',
                                    'label' => esc_html__( 'Heading Background Image', 'yolo-kidzone' ),
                                    'desc'  => esc_html__( 'An unique heading image for this post. If leave it blank, the default heading image of Blog ( in Customizer settings ) will be used.', 'yolo-kidzone'),
                                    'type'  => 'image',
                                );
            }

            $helper->add_meta_box( $meta_box );

        }

        // Teaching Skills Functions
        function yolo_teacher_meta_box_skills_callback( $post, $id, $type, $meta, $std, $field ) {
            ?>
            <div class="yolo-teacher-skills-meta-box">
                <?php wp_nonce_field( '_yolo_teacher_skills_meta_box_save', '_yolo_teacher_skills_meta_box_nonce' ); ?>
                <table class="widefat">
                    <thead>
                    <tr>
                        <th class="sort">&nbsp;</th>
                        <th width="70%" colspan="2"><?php esc_html_e( 'Skills', 'yolo-kidzone' ); ?> </th>
                        <th>&nbsp;</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $skills = get_post_meta( $post->ID, '_teacher_skills', true );

                    if($skills){
                        foreach ( (array)$skills as $key => $skill ) :
                            echo $this->yolo_teacher_skills_meta_box_row( $key, $skill );
                        endforeach;
                    }
                    ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <th colspan="5">
                            <a href="#" class="button insert" data-row="<?php echo esc_attr($this->yolo_teacher_skills_meta_box_row( $key='', $skill='' )); ?>"><?php esc_html_e( 'Add Skills', 'yolo-kidzone' ); ?></a>
                        </th>
                    </tr>
                    </tfoot>
                </table>
            </div>
            <?php
        }

        function yolo_teacher_skills_meta_box_row( $key, $skill ) {
            ob_start();
            ?>
            <tr>
                <td class="sort"></td>
                <td class="file_value">
                    <input type="text" class="input_text" placeholder="<?php esc_html_e( 'Skill Name', 'yolo-kidzone' ); ?>" name="_yolo_teacher_skills_name[]" value="<?php if( isset($key) && $key !='' ): echo esc_attr($key); endif; ?>" />
                    <input type="text" class="input_text" placeholder="Value" name="_yolo_teacher_skills_value[]" value="<?php if( isset($skill) && $skill !='' ): echo esc_attr($skill); endif; ?>">
                </td>
                <td width="1%"><a href="#" class="delete"><?php esc_html_e( 'Delete', 'yolo-kidzone' ); ?></a></td>
            </tr>
            <?php
            return ob_get_clean();
        }

        function yolo_teacher_save_skills_meta_box($post_id, $post){


            if ( defined( 'DOING_AUTOSAVE' ) || is_int( wp_is_post_revision( $post ) ) || is_int( wp_is_post_autosave( $post ) ) ) {
                return;
            }

            if ( ! isset( $_POST['_yolo_teacher_skills_meta_box_nonce'] ) || ! isset( $_POST['_yolo_teacher_skills_meta_box_nonce'] ) || ! wp_verify_nonce( $_POST['_yolo_teacher_skills_meta_box_nonce'], '_yolo_teacher_skills_meta_box_save' ) )
                return;
            // Check the post being saved == the $post_id to prevent triggering this call for other save_post events
            if ( empty( $_POST['post_ID'] ) || $_POST['post_ID'] != $post_id ) {
                return;
            }
            // Check user has permission to edit
            if ( ! current_user_can( 'edit_post', $post_id ) ) {
                return;
            }

            $skills = array();
            $skills_name           = isset( $_POST['_yolo_teacher_skills_name'] )  ? array_map( 'trim', $_POST['_yolo_teacher_skills_name'] ) : array();
            $skills_value           = isset( $_POST['_yolo_teacher_skills_value'] )  ? array_map( 'trim', $_POST['_yolo_teacher_skills_value'] ) : array();
            $skills_value_size       = sizeof( $skills_value );

            for ( $i = 0; $i < $skills_value_size; $i ++ ) {
                if ( ! empty( $skills_value[ $i ] ) ) {
                    $name                   = sanitize_text_field( $skills_name[ $i ] );
                    $value                  = sanitize_text_field( $skills_value[ $i ] );
                    $skills[$name]          = $value;
                }
            }

            update_post_meta( $post_id, '_teacher_skills', $skills );
        }

        // Teacher Performance Functions

        function yolo_teacher_meta_box_performance_callback( $post, $id, $type, $meta, $std, $field ) {
            ?>
            <div class="yolo-performance-meta-box">
                <?php wp_nonce_field( '_yolo_performance_meta_box_save', '_yolo_performance_meta_box_nonce' ); ?>
                <table class="widefat">
                    <thead>
                    <tr>
                        <th class="sort">&nbsp;</th>
                        <th width="70%" colspan="2"><?php esc_html_e( 'Performance', 'yolo-kidzone' ); ?> </th>
                        <th>&nbsp;</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $performance = get_post_meta( $post->ID, '_teacher_performance', true );

                    if($performance){
                        foreach ( (array)$performance as $key => $perform ) :
                            echo $this->yolo_teacher_performance_meta_box_row( $key, $perform );
                        endforeach;
                    }
                    ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <th colspan="5">
                            <a href="#" class="button insert" data-row="<?php echo esc_attr($this->yolo_teacher_performance_meta_box_row( $key='', $perform='' )); ?>"><?php esc_html_e( 'Add Performance', 'yolo-kidzone' ); ?></a>
                        </th>
                    </tr>
                    </tfoot>
                </table>
            </div>
            <?php
        }

        function yolo_teacher_performance_meta_box_row( $key, $perform ) {
            ob_start();
            // Performance options
            $performance_selector = apply_filters( 'performance_selector', array(
                'excellent'     => esc_html__( 'Excellent', 'yolo-kidzone' ),
                'good'          => esc_html__( 'Good', 'yolo-kidzone' ),
                'fair'          => esc_html__( 'Fair', 'yolo-kidzone' ),
                'poor'          => esc_html__( 'Poor', 'yolo-kidzone' )
            ) );
            ?>
            <tr>
                <td class="sort"></td>
                <td class="file_value">
                    <input type="text" class="input_text" placeholder="<?php esc_html_e( 'Performance Name', 'yolo-kidzone' ); ?>" name="_yolo_teacher_performance_name[]" value="<?php if( isset($key) && $key !='' ): echo esc_attr($key); endif; ?>" />
                    <select id="yolo_teacher_performance" name="_yolo_teacher_performance_value[]">
                        <option value=""><?php esc_html_e( 'Select Option', 'yolo-kidzone' ); ?></option>
                        <?php foreach ( $performance_selector as $value => $label ) : ?>
                        <option value="<?php echo esc_attr( $value ); ?>" <?php selected( $perform, $value, true ); ?> ><?php echo esc_html( $label ); ?></option>';
                        <?php endforeach; ?>
                   </select>
                </td>
                <td width="1%"><a href="#" class="delete"><?php esc_html_e( 'Delete', 'yolo-kidzone' ); ?></a></td>
            </tr>
            <?php
            return ob_get_clean();
        }

        function yolo_teacher_save_performance_meta_box($post_id, $post){


            if ( defined( 'DOING_AUTOSAVE' ) || is_int( wp_is_post_revision( $post ) ) || is_int( wp_is_post_autosave( $post ) ) ) {
                return;
            }

            if ( ! isset( $_POST['_yolo_performance_meta_box_nonce'] ) || ! isset( $_POST['_yolo_performance_meta_box_nonce'] ) || ! wp_verify_nonce( $_POST['_yolo_performance_meta_box_nonce'], '_yolo_performance_meta_box_save' ) )
                return;
            // Check the post being saved == the $post_id to prevent triggering this call for other save_post events
            if ( empty( $_POST['post_ID'] ) || $_POST['post_ID'] != $post_id ) {
                return;
            }
            // Check user has permission to edit
            if ( ! current_user_can( 'edit_post', $post_id ) ) {
                return;
            }

            $performance = array();
            $performance_name           = isset( $_POST['_yolo_teacher_performance_name'] )  ? array_map( 'trim', $_POST['_yolo_teacher_performance_name'] ) : array();
            $performance_value           = isset( $_POST['_yolo_teacher_performance_value'] )  ? array_map( 'trim', $_POST['_yolo_teacher_performance_value'] ) : array();
            $performance_value_size       = sizeof( $performance_value );

            for ( $i = 0; $i < $performance_value_size; $i ++ ) {
                if ( ! empty( $performance_value[ $i ] ) ) {
                    $name                   = sanitize_text_field( $performance_name[ $i ] );
                    $value                  = sanitize_text_field( $performance_value[ $i ] );
                    $performance[$name]          = $value; 
                    // $pro_hash               = $post_id.'_'.$value.wp_rand(0,100);
                    // $performance[ $pro_hash ]    = $value;
                }
            }

            update_post_meta( $post_id, '_teacher_performance', $performance );
        }

        // Teacher Testimonials functions
        function yolo_teacher_testimonials_meta_box_callback( $post, $id, $type, $meta, $std, $field ) {
            $post_testimonials = $this->yolo_get_posts_post_type( 'testimonial' );
            $teacher_testimonials = get_post_meta( $post->ID, '_teacher_testimonials', true );
           
        ?>
            <select id="yolo_teacher_testimonials" name="_yolo_teacher_testimonials_id[]" data-placeholder="<?php esc_html_e( 'Select Testimonials(Default: ALL)', 'yolo-kidzone' ); ?>" style="width: 300px;" multiple class="chosen-select">
            <?php if( $post_testimonials->have_posts() ) : 
                while( $post_testimonials->have_posts() ) :
                    $post_testimonials->the_post();
                ?>
                    <option value="<?php the_ID(); ?>" class="teacher-testimonials" 
                        <?php
                            if( $teacher_testimonials ) : 
                                foreach( $teacher_testimonials as $testimonial ) :
                                    selected( get_the_ID(), $testimonial, true );
                                endforeach; 
                            endif;
                        ?> 
                    > <!-- end option -->
                        <?php echo esc_html( the_title() ); ?>
                    </option>';
            <?php 
                endwhile;
            endif;
            ?>
            </select>
        <?php }

        function yolo_get_posts_post_type( $type ) {
            $yolo_args = array(
                'post_type'     => $type,
                'posts_per_page'=> '9999', // @TODO: How to show all testimonial
                'post_status'   => 'publish'
            );
            $yolo_query = new WP_Query( $yolo_args );

            return $yolo_query;
        }

        function yolo_teacher_save_testimonials_meta_box( $post_id, $post ) {

            if ( defined( 'DOING_AUTOSAVE' ) || is_int( wp_is_post_revision( $post ) ) || is_int( wp_is_post_autosave( $post ) ) ) {
                return;
            }

            // Check the post being saved == the $post_id to prevent triggering this call for other save_post events
            if ( empty( $_POST['post_ID'] ) || $_POST['post_ID'] != $post_id ) {
                return;
            }
            // Check user has permission to edit
            if ( ! current_user_can( 'edit_post', $post_id ) ) {
                return;
            }

            $testimonials           = isset( $_POST['_yolo_teacher_testimonials_id'] )  ? array_map( 'trim', $_POST['_yolo_teacher_testimonials_id'] ) : array();

            // Update only if post type is event - all other post type run over here (generate metabox cause this in $_POST)
            if ( get_post_type( $post ) == 'teacher' ) {
                update_post_meta( $post_id, '_teacher_testimonials', $testimonials );
            }
        }

        // Teacher Contact Function
        function yolo_teacher_contact_meta_box_callback( $post, $id, $type, $meta, $std, $field ) {
            $post_contact = $this->yolo_get_posts_post_type( 'wpcf7_contact_form' );
            $teacher_contact = get_post_meta( $post->ID, '_teacher_contact', true );
        ?>
            <select id="yolo_teacher_contact" name="_yolo_teacher_contact_id">
                    <option value=""><?php esc_html_e( 'Select Contact Form', 'yolo-kidzone' ); ?></option>
            <?php if( $post_contact->have_posts() ) : 
                while( $post_contact->have_posts() ) :
                    $post_contact->the_post();
                ?>
                    <option value="<?php the_ID(); ?>" class="<?php echo $teacher_contact;  ?>" <?php selected( get_the_ID(), $teacher_contact, true ); ?> ><?php echo esc_html( the_title() ); ?></option>';
            <?php 
                endwhile;
            endif;
            ?>
            </select>
        <?php }

        function yolo_teacher_save_teacher_contact_meta_box( $post_id, $post ) {

            if ( defined( 'DOING_AUTOSAVE' ) || is_int( wp_is_post_revision( $post ) ) || is_int( wp_is_post_autosave( $post ) ) ) {
                return;
            }

            // Check the post being saved == the $post_id to prevent triggering this call for other save_post teachers
            if ( empty( $_POST['post_ID'] ) || $_POST['post_ID'] != $post_id ) {
                return;
            }
            // Check user has permission to edit
            if ( ! current_user_can( 'edit_post', $post_id ) ) {
                return;
            }

            // Update only if post type is teacher - all other post type run over here (generate metabox cause this in $_POST)
            if ( get_post_type( $post ) == 'teacher' ) {
                $contact_id = sanitize_text_field( $_POST['_yolo_teacher_contact_id'] );
                update_post_meta( $post_id, '_teacher_contact', $contact_id );
            }
        }

    }
    new Yolo_Teacher();
endif;









