<?php
/**
 * Register YOLO testimonial.
 * This file register Item and Category for YOLO testimonial.
 *
 * @package    YOLO Framework
 * @subpackage YOLO testimonial
 * @version    1.0.0
 * @author     Kan Nguyen <khanhnq@yolotheme.com>
 * @copyright  Copyright (c) 2015, YoloTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://yolotheme.com
 */

if( !class_exists('Yolo_Testimonial') ):

    class Yolo_Testimonial{

        public function __construct(){
            add_action('init', array($this,'yolo_register_post_type'));
            if( is_admin() ){
                add_action('add_meta_boxes', array($this,'yolo_register_meta_box'));
            }
        }
        public function yolo_register_post_type(){

            // Text for YOLO testimonial.
            $testimonial_labels = array(
                'name' => __('Testimonial', 'yolo-kidzone') ,
                'singular_name' => __('Testimonial', 'yolo-kidzone') ,
                'menu_name' => __('Testimonial', 'yolo-kidzone') ,
                'add_new' => __('Add New', 'yolo-kidzone') ,
                'add_new_item' => __('Add New testimonial Item', 'yolo-kidzone') ,
                'edit_item' => __('Edit testimonial Item', 'yolo-kidzone') ,
                'new_item' => __('Add New testimonial Item', 'yolo-kidzone') ,
                'view_item' => __('View testimonial', 'yolo-kidzone') ,
                'search_items' => __('Search testimonial', 'yolo-kidzone') ,
                'not_found' => __('No testimonial items found', 'yolo-kidzone') ,
                'not_found_in_trash' => __('No testimonial items found in trash', 'yolo-kidzone') ,
                'parent_item_colon' => ''
            );

            $admin_icon = YOLO_PLUGIN_PATH . '/assets/images/yolo20x20.png';
            if ( floatval( get_bloginfo( 'version' ) ) >= 3.8 ) {
                $admin_icon = 'dashicons-testimonial';
            }

            $testimonial_slug = 'yolo-testimonial';

            // Options
            $testimonial_args = array(
                'labels' => $testimonial_labels,
                'public' => false,
                'publicly_queryable' => true,
                'show_ui' => true,
                'show_in_menu' => true,
                'menu_position' => 5,
                'menu_icon' => $admin_icon,
                'capability_type' => 'post',
                'hierarchical' => false,
                'supports' => array(
                    'title',
                    'editor',
//                'excerpt',
//                'thumbnail',
                    // 'comments',
                    //'custom-fields',
                    'revisions'
                ) ,
                'has_archive' => true,
                'rewrite' => array(
                    'slug' => $testimonial_slug,
                    'with_front' => false
                )
            );

            register_post_type('testimonial', $testimonial_args);

            // Register a taxonomy for Project Categories.
            $category_labels = array(
                'name' => __('Testimonial Categories', 'yolo-kidzone') ,
                'singular_name' => __('Testimonial Category', 'yolo-kidzone') ,
                'menu_name' => __('Testimonial Categories', 'yolo-kidzone') ,
                'all_items' => __('All Testimonial Categories', 'yolo-kidzone') ,
                'edit_item' => __('Edit Testimonial Category', 'yolo-kidzone') ,
                'view_item' => __('View Testimonial Category', 'yolo-kidzone') ,
                'update_item' => __('Update Testimonial Category', 'yolo-kidzone') ,
                'add_new_item' => __('Add New Testimonial Category', 'yolo-kidzone') ,
                'new_item_name' => __('New Testimonial Category Name', 'yolo-kidzone') ,
                'parent_item' => __('Parent Testimonial Category', 'yolo-kidzone') ,
                'parent_item_colon' => __('Parent Testimonial Category:', 'yolo-kidzone') ,
                'search_items' => __('Search Testimonial Categories', 'yolo-kidzone') ,
                'popular_items' => __('Popular Testimonial Categories', 'yolo-kidzone') ,
                'separate_items_with_commas' => __('Separate Testimonial Categories with commas', 'yolo-kidzone') ,
                'add_or_remove_items' => __('Add or remove Testimonial Categories', 'yolo-kidzone') ,
                'choose_from_most_used' => __('Choose from the most used Testimonial Categories', 'yolo-kidzone') ,
                'not_found' => __('No Testimonial Categories found', 'yolo-kidzone') ,
            );

            $category_args = array(
                'labels' => $category_labels,
                'public' => false,
                'show_ui' => true,
                'show_in_nav_menus' => false,
                'show_tagcloud' => false,
                'show_admin_column' => true,
                'hierarchical' => true,
                'query_var' => true,
                'rewrite' => array(
                    'slug' => 'testimonial_category',
                    'with_front' => false
                ) ,
            );

            register_taxonomy('testimonial_category', array(
                'testimonial'
            ) , $category_args);
        }

        public function yolo_register_meta_box(){
            // Declare helper object
            $prefix = '_yolo_wp_post';
            $helper = new YOLO_Meta_Boxes_Helper($prefix, array(
                'page' => 'testimonial'
            ));
            // Post type: Gallery
            $meta_box = array(
                'id' => "{$prefix}_meta_box_testimonial",
                'title' => __('Testimonial options', 'yolo-kidzone'),
                'fields' => array(
                    array(
                        'id' => "{$prefix}_avatar",
                        'label' => __( 'Avatar', 'yolo-kidzone' ),
                        'type' => 'image',
                    ),
                    array(
                        'id' => "{$prefix}_name",
                        'label' => __( 'Your Name', 'yolo-kidzone' ),
                        'type' => 'text',
                    ),
                    array(
                        'id' => "{$prefix}_position",
                        'label' => __( 'Your Position', 'yolo-kidzone' ),
                        'type' => 'text',
                    ),
                )
            );

            $helper->add_meta_box($meta_box);
        }

    }
    new Yolo_Testimonial();
endif;








