<?php
/**
 * YOLO Visual Composer Add-ons
 *
 * Customize Visual Composer to suite YOLO Framework
 *
 * @package    YOLO Framework
 * @subpackage YOLO Visual Composer Add-ons
 * @version    1.0.0
 * @author     Kan Nguyen <khanhnq@yolotheme.com>
 * @copyright  Copyright (c) 2014, YoloTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://yolotheme.com
 */
//
// Variables.
//
$category_name    = esc_html__( 'Kidzone', 'yolo-kidzone' );
$param_class_name = 'class';
$param_class_heading = esc_html__( 'Class', 'yolo-kidzone' );
$param_class_description = esc_html__( '(Optional) Enter a unique class name.', 'yolo-kidzone' );
$param_class_type = 'textfield';
$param_class_holder = 'div';

$param_custom_style_name = 'custom_style';
$param_custom_style_heading = esc_html__( 'Custom Style', 'yolo-kidzone' );
$param_custom_style_description = esc_html__( '(Optional) Enter inline CSS.', 'yolo-kidzone' );
$param_custom_style_type = 'textfield';
$param_custom_style_holder = 'div';

$param_holder = 'div';

// custom [row]
vc_add_param('vc_row', array(
	"type"        =>  "checkbox",
	"admin_label" =>  true,
	"heading"     =>  "Using Container",
	"param_name"  =>  "container_width",
	"description" =>  esc_html__('If checked container will be set to width 1170px for content.','yolo-kidzone'),
	'weight'      => 1,
	'value'       => array( esc_html__( 'Yes', 'yolo-kidzone' ) => 'yes' )
	)
);


// [yolo_service]
vc_map(array(
	"name" => esc_html__("Yolo Service", 'yolo-kidzone'),
	"base" => "yolo_service",
	"category" => $category_name,
	'description' => esc_html__( 'Display service box', 'yolo-kidzone' ),
	"params" => array(
		array(
			'param_name'  => 'style',
			'heading'     => esc_html__( 'Style', 'yolo-kidzone' ),
			'description' => '',
			'type'        => 'dropdown',
			'value'       => array(
				'Home 1'   =>  'index-1',
				'Home 2'   =>  'index-2'
				)
			),
		array(
			'type'          =>  'textfield',
			'class'         =>  'title',
			'heading'       =>  esc_html__('Title','yolo-kidzone'),
			'param_name'    =>  'title',
			'value'         =>  ''
			),
		array(
			'type'          =>  'textarea_html',
			'class'         =>  'content',
			'heading'       =>  esc_html__('Description','yolo-kidzone'),
			'param_name'    =>  'content',
			'dependency' => array( 'element' => 'style', 'value' =>array( 'index-1'))
			),
		array(
			'param_name'  => 'service_image',
			'class'		  => 'service_image',
			'heading'     => esc_html__( 'Service Image', 'yolo-kidzone' ),
			'type'        => 'attach_image',
			'value'       => ''
			),
		array(
			'param_name'    =>  'background_color',
			'heading'       =>  esc_html__('Background color', 'yolo-kidzone'),
			'description'   =>  '',
			'type'          =>  'colorpicker',
			'value'       => ''
			),
		)
	));


// [yolo_clients]
vc_map(array(
	'name'      =>  esc_html__('Yolo Clients','yolo-kidzone'),
	'base'      =>  'yolo_clients',
	'category'  =>   $category_name,
	'description' => esc_html__( 'Display clients logo', 'yolo-kidzone' ),
	'params'    =>  array(
		array(
			'param_name'  => 'style',
			'heading'     => esc_html__( 'Style', 'yolo-kidzone' ),
			'description' => '',
			'type'        => 'dropdown',
			'value'       => array(
				esc_html__( 'Slider', 'yolo-kidzone' ) => 'slider',
				esc_html__( 'Default', 'yolo-kidzone' ) => 'default'
				)
			),
		array(
			'param_name'  => 'control',
			'heading'     => esc_html__( 'Status Button', 'yolo-kidzone' ),
			'description' => '',
			'type'        => 'dropdown',
			'dependency'    => array(
				'element'   => 'style',
				'value'     => array( 'slider' )
				),
			'value'       => array(
				esc_html__( 'Show', 'yolo-kidzone' ) => 'show',
				esc_html__( 'Hide', 'yolo-kidzone' ) => 'hide'
				)
			),
		array(
				'type' => 'param_group',
				'heading' => esc_html__( 'Values', 'yolo-kidzone' ),
				'param_name' => 'values',
				'description' => esc_html__( 'Add Links and images', 'yolo-kidzone' ),
				'value' => urlencode( json_encode( array(
					array(
						'label' => esc_html__( 'Link for Image 1', 'yolo-kidzone' ),
						'value' => '',
					),
					array(
						'label' => esc_html__( 'Link for Image 2', 'yolo-kidzone' ),
						'value' => '',
					),
					array(
						'label' => esc_html__( 'Link for Image 3', 'yolo-kidzone' ),
						'value' => '',
					),
				) ) ),
				'params' => array(
					array(
						'type' => 'textfield',
						'heading' => esc_html__( 'Label', 'yolo-kidzone' ),
						'param_name' => 'label',
						'description' => esc_html__( 'Enter Link for Clients', 'yolo-kidzone' ),
						'admin_label' => true,
					),
					array(
						'type' => 'attach_image',
						'heading' => esc_html__( 'Select Image', 'yolo-kidzone' ),
						'param_name' => 'value',
						'description' => esc_html__( 'Select image of Clients.', 'yolo-kidzone' ),
					),
				),
			),
		array(
			'param_name'  => 'target',
			'heading'     => esc_html__( 'Custom link target', 'yolo-kidzone' ),
			'description' => esc_html__('Select where to open custom links.', 'yolo-kidzone'),
			'type'        => 'dropdown',
			'value'       => array(
				'Same window'   =>  'same',
				'New window'    =>  'new'
				)
			)
		)
));

// [yolo_newsletter]
global $yolo_mailchimp;
$api_key = yolo_get_option('yolo_mailchimp_api_key', '');
$mail_list = !empty( $api_key ) ? $yolo_mailchimp->yolo_get_mail_lists( $api_key ) : '';
$mail_ch = array();
if ( isset( $mail_list ) && !empty( $mail_list ) ):
	$mail_ch[ 0 ] = '';
	foreach( $mail_list as $id => $list_name ):
		$mail_ch[ $list_name ] = $id;	
	endforeach;
endif;
	vc_map(array(
		'name'      =>  esc_html__('Yolo Newsletter','yolo-kidzone'),
		'base'      =>  'yolo_newsletter',
		'category'  =>   $category_name,
		'description' => esc_html__( 'Show newsletter', 'yolo-kidzone' ),
		'params'    =>  array(
			array(
				'type'          =>  'textfield',
				'class'         =>  '',
				'heading'       =>  esc_html__('Title','yolo-kidzone'),
				'param_name'    =>  'title',
				'value'         =>  ''
				),
			array(
				'param_name'  => 'bg_image',
				'heading'     => esc_html__( 'Background Title Image', 'yolo-kidzone' ),
				'description' => '',
				'type'        => 'attach_image',
				'value'       => ''
				),
			array(
				'type'          =>  'textfield',
				'class'         =>  '',
				'heading'       =>  esc_html__('Subscribe text','yolo-kidzone'),
				'param_name'    =>  'subscribe_text',
				'value'         =>  ''
				),
			array(
				'param_name'    =>  'mail_list',
				'heading'       =>  esc_html__( 'Subscribe Mail List:', 'yolo-kidzone' ),
				'type'          =>  'dropdown',
				'value'         =>  $mail_ch
				),
			array(
				'type'          =>  'textfield',
				'class'         =>  '',
				'heading'       =>  esc_html__('Phone number','yolo-kidzone'),
				'param_name'    =>  'phone_number',
				'value'         =>  ''
				),
			)
		));

// [yolo_testimonial]
vc_map(array(
	'name'      =>  esc_html__('Yolo Testimonial','yolo-kidzone'),
	'base'      =>  'yolo_testimonial',
	'category'  =>   $category_name,
	'description' => esc_html__( 'Display your testimonials', 'yolo-kidzone' ),
	'params'    =>  array(
		array(
			'param_name' => 'testimonials',
			'heading' => esc_html__('Select testimonials', 'yolo-kidzone'),
			'description' => '',
			'type' => 'yl_testimonials',
			'value' => ''
			),
		array(
			'param_name'  => 'style',
			'heading'     => esc_html__( 'Style', 'yolo-kidzone' ),
			'description' => '',
			'type'        => 'dropdown',
			'value'       => array(
				esc_html__( 'Style 1', 'yolo-kidzone' ) => 'style1',
				esc_html__( 'Style 2', 'yolo-kidzone' ) => 'style2'
				)
			),		

		array(
			'param_name'  => 'columns',
			'heading'     => esc_html__( 'Columns', 'yolo-kidzone' ),
			'description' => '',
			'type'        => 'dropdown',
			'value'       => array(
				esc_html__( '1 Column', 'yolo-kidzone' ) => '1',
				esc_html__( '2 Column', 'yolo-kidzone' ) => '2',
				esc_html__( '3 Column', 'yolo-kidzone' ) => '3',
				esc_html__( '4 Column', 'yolo-kidzone' ) => '4',
				esc_html__( '5 Column', 'yolo-kidzone' ) => '5',
				esc_html__( '6 Column', 'yolo-kidzone' ) => '6',
				)
			),		
		array(
			'param_name'    => 'play',
			'heading'       => esc_html__( 'Auto play', 'yolo-kidzone' ),
			'description'   => '',
			'type'          => 'dropdown',
			'value'         => array(
				esc_html__('Yes','yolo-kidzone')    => 'true',
				esc_html__('No','yolo-kidzone')    => 'false'
				)
			),
		)
	));


// [yolo_image_slider]
vc_map(array(
	"name"      =>  esc_html__("Yolo Image Slider", "yolo-kidzone"),
	"base"      =>  "yolo_image_slider",
	"category"  =>  $category_name,
	'description' => esc_html__( 'Show about slider content', 'yolo-kidzone' ),
	"params"    =>  array( 
		array(
				'type' => 'param_group',
				'heading' => esc_html__( 'Values', 'yolo-kidzone' ),
				'param_name' => 'values',
				'description' => esc_html__( 'Add text and image for slider', 'yolo-kidzone' ),
				'value' => urlencode( json_encode( array(
					array(
						'label' => esc_html__( 'Text for slider 1', 'yolo-kidzone' ),
						'value' => '',
					),
					array(
						'label' => esc_html__( 'Text for slider 2', 'yolo-kidzone' ),
						'value' => '',
					),
					array(
						'label' => esc_html__( 'Text for slider 3', 'yolo-kidzone' ),
						'value' => '',
					),
				) ) ),
				'params' => array(
					array(
						'type' => 'textfield',
						'heading' => esc_html__( 'Label', 'yolo-kidzone' ),
						'param_name' => 'label',
						'description' => esc_html__( 'Enter text for slider', 'yolo-kidzone' ),
						'admin_label' => true,
					),
					array(
						'type' => 'attach_image',
						'heading' => esc_html__( 'Select Image', 'yolo-kidzone' ),
						'param_name' => 'value',
						'description' => esc_html__( 'Select image of Slider.', 'yolo-kidzone' ),
					),
				),
			),
		), 
		
));


// [blog_post]
vc_map( 
	array( 
		'base' => 'blog_post', 
		'name' => esc_html__( 'Yolo Post', 'yolo-kidzone' ), 
		'class' => 'yolo-vc-element yolo-vc-element-blog-test', 
		'category' => $category_name, 
		'description' => 'Get blog post', 
		'params' => array( 
			array( 
				'param_name' => 'layout', 
				'heading' => esc_html__( 'Layout', 'yolo-kidzone' ), 
				'description' => '', 
				'type' => 'dropdown', 
				'value' => array(
					esc_html__( 'Default List', 'yolo-kidzone' ) => 'list', 
					esc_html__( 'Masonry', 'yolo-kidzone' ) => 'masonry' , 
					esc_html__( 'Medium' , 'yolo-kidzone' ) => 'medium' ,
					esc_html__( 'Grid' , 'yolo-kidzone' ) => 'grid',
					esc_html__( 'Timeline' ,'yolo-kidzone' ) => 'timeline'),
				),
			array( 
				'type' => 'dropdown', 
				'heading' => esc_html__( 'Pagination', 'yolo-kidzone' ), 
				'param_name' => 'pagination', 
				'value' => array( 
					esc_html__( 'Page Number', 'yolo-kidzone' ) => 'page_num', 
					esc_html__( 'Load More Button', 'yolo-kidzone' ) => 'loadmore', 
					esc_html__( 'Infinite Scrolling', 'yolo-kidzone' ) => 'infinite_scroll', 
					esc_html__( 'No', 'yolo-kidzone' ) => 'no' ), 
				'description' => esc_html__( 'Choose pagination type.', 'yolo-kidzone' ) 
			),
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Load More Button Text', 'yolo-kidzone' ), 
				'param_name' => 'loadmore_text', 
				'dependency' => array( 'element' => "pagination", 'value' => array( 'loadmore' ) ), 
				'value' => esc_html__( 'Load More', 'yolo-kidzone' ) 
			),
			array( 
				'param_name' => 'columns', 
				'heading' => esc_html__( 'Columns', 'yolo-kidzone' ), 
				'type' => 'dropdown', 
				'value' => array( 
					esc_html__( 'Two', 'yolo-kidzone' ) => 2, 
					esc_html__( 'Three', 'yolo-kidzone' ) => 3, 
					esc_html__( 'Four', 'yolo-kidzone' ) => 4, 
					esc_html__( 'Five', 'yolo-kidzone' ) => 5, 
					esc_html__( 'Six', 'yolo-kidzone' ) => 6 ), 
				'dependency' => array( 'element' => 'layout', 'value' => array( 'masonry','grid' ) ) 
			),
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Posts Per Page', 'yolo-kidzone' ), 
				'param_name' => 'posts_per_page', 
				'value' => 5, 
				'description' => esc_html__( 'Select number of posts per page.Set "-1" to display all', 'yolo-kidzone' ) 
			),	
			array( 
				'param_name' => 'categories', 
				'heading' => esc_html__( 'Blog Categories', 'yolo-kidzone' ), 
				'description' => '', 
				'type' => 'post_categories', 
			),
			array( 
				'param_name' => 'orderby', 
				'heading' => esc_html__( 'Order By', 'yolo-kidzone' ), 
				'description' => '', 
				'type' => 'dropdown', 
				'value' => array( 
					esc_html__( 'Recent First', 'yolo-kidzone' ) => 'latest', 
					esc_html__( 'Older First', 'yolo-kidzone' ) => 'oldest', 
					esc_html__( 'Title Alphabet', 'yolo-kidzone' ) => 'alphabet', 
					esc_html__( 'Title Reversed Alphabet', 'yolo-kidzone' ) => 'ralphabet' ) 
			), 
			array( 
				'param_name' => 'hide_readmore', 
				'heading' => esc_html__( 'Hide Readmore link', 'yolo-kidzone' ), 
				'type' => 'checkbox', 
				'value' => array( '' => 'true' ) 
			), 
			array( 
				'param_name' => 'excerpt_length', 
				'heading' => esc_html__( 'Excerpt length', 'yolo-kidzone' ), 
				'type' => 'textfield', 
				'std' => 55, 
			),
			array( 
				'param_name' => 'title', 
				'heading' => esc_html__( 'Heading (optional)', 'yolo-kidzone' ), 
				'type' => 'textfield', 
			),
			array( 
				'param_name' => 'sub_title', 
				'heading' => esc_html__( 'Sub-Heading (optional)', 'yolo-kidzone' ), 
				'type' => 'textfield', 
			)
		)
	)
);

// [yolo_recent_news]
vc_map(array(
	"name"      =>  esc_html__("Yolo Recent News", "yolo-kidzone"),
	"base"      =>  "yolo_recent_news",
	"category"  =>  $category_name,
	'description' => esc_html__( 'Show latest post', 'yolo-kidzone' ),
	"params"    =>  array(      
		array(
			'param_name'  => 'style',
			'heading'     => esc_html__( 'Choose style for recent news', 'yolo-kidzone' ),
			'description' => '',
			'type'        => 'dropdown',
			'value'       => array(
				esc_html__( 'Index-1', 'yolo-kidzone' )   => 'index-1',
				esc_html__( 'Index-2', 'yolo-kidzone' )   => 'index-2'
				)
			),
		array( 
			'param_name' => 'categories', 
			'heading' => esc_html__( 'Categories', 'yolo-kidzone' ), 
			'description' => esc_html__( 
				'Select categories.', 
				'yolo-kidzone' ), 
			'type' => 'post_categories', 
		),
		array( 
			'param_name' => 'posts_per_page', 
			'heading' => esc_html__( 'Posts per page', 'yolo-kidzone' ), 
			'type' => 'textfield', 
		),
		array( 
			'param_name' => 'excerpt_length', 
			'heading' => esc_html__( 'Excerpt Length', 'yolo-kidzone' ), 
			'type' => 'textfield', 
			'std' => 20, 
		),
		array( 
			'param_name' => 'class', 
			'heading' => esc_html__( 'Class', 'yolo-kidzone' ), 
			'description' => esc_html__( '(Optional) Enter a unique class name.', 'yolo-kidzone' ), 
			'type' => 'textfield', 
		)
	)
));

/* [yolo_product_masonry] */
 vc_map(
 	array(
 		'base' => 'yolo_product_masonry',
 		'name' => __( 'Yolo Products Masonry', 'yolo-kidzone' ),
 		'class' => 'yolo-vc-element yolo-vc-element-portfolio',
 		'category' => $category_name,
 		'description' => '',
 		'params' => array(
 			array(
 				"type" => "product_categories",
 				"heading" => __( "Categories", 'yolo-kidzone' ),
 				"param_name" => "category",
 			),
			array(
 				"type" => "dropdown",
 				"heading" => __( "Filter alignment", 'yolo-kidzone' ),
 				"param_name" => "ms_align",
				"value" => array(
					__( 'Center', 'yolo-kidzone' ) => 'center',
					__( 'Left', 'yolo-kidzone' ) => 'left',
					__( 'Right', 'yolo-kidzone' ) => 'right')),
			array(
				'type' => 'dropdown',
				'heading' => __( 'Pagination', 'yolo-kidzone' ),
				'param_name' => 'pagination',
				'value' => array(
					__( 'Page Number', 'yolo-kidzone' ) => 'page_num',
					__( 'Load More Button', 'yolo-kidzone' ) => 'loadmore',
					__( 'Infinite Scrolling', 'yolo-kidzone' ) => 'infinite_scroll',
					__( 'No', 'yolo-kidzone' ) => 'no' ),
				'description' => __( 'Choose pagination type.', 'yolo-kidzone' ) ),
 			array(
 				"type" => "textfield",
 				"heading" => __( "Product Per Page", 'yolo-kidzone' ),
 				"param_name" => "per_page",
 				"value" => 12 ),
 			array(
 				"type" => "dropdown",
 				"heading" => __( "Columns", 'yolo-kidzone' ),
 				"param_name" => "columns",
 				"std" => 4,
 				"value" => array( 2, 3, 4 ) ),
 			array(
 				"type" => "dropdown",
 				"heading" => __( "Products Ordering", 'yolo-kidzone' ),
 				"param_name" => "orderby",
 				'class' => 'dhwc-woo-product-page-dropdown',
 				"value" => array(
 					__( 'Publish Date', 'yolo-kidzone' ) => 'date',
 					__( 'Random', 'yolo-kidzone' ) => 'rand',
 					__( 'Alphabetic', 'yolo-kidzone' ) => 'title',
 					__( 'Popularity', 'yolo-kidzone' ) => 'popularity',
 					__( 'Rate', 'yolo-kidzone' ) => 'rating',
 					__( 'Price', 'yolo-kidzone' ) => 'price' ) ),
 			array(
 				"type" => "dropdown",
 				"class" => "",
 				"heading" => __( "Sorting", 'yolo-kidzone' ),
 				"param_name" => "order",
 				"value" => array(
 					__( 'Ascending', 'yolo-kidzone' ) => 'asc',
 					__( 'Descending', 'yolo-kidzone' ) => 'desc' ) ),
			array(
 				"type" => "dropdown",
 				"class" => "",
 				"heading" => __( "Show/hide sorting", 'yolo-kidzone' ),
 				"param_name" => "show_hide",
 				"value" => array(
 					__( 'Show', 'yolo-kidzone' ) => 'true',
 					__( 'Hide', 'yolo-kidzone' ) => 'false' ) ),

 			)
 ));


/* [yolo_pricing_plans] */
vc_map( array(
	'name' => esc_html__( 'Yolo Pricing Plans', 'yolo-kidzone' ),
	'base' => 'yolo_pricing_plans',
	'category' => $category_name,
	'description'	=> esc_html__( 'Display pricing plans', 'yolo-kidzone' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Title', 'yolo-kidzone' ),
			'param_name' => 'title',
			'description' => esc_html__( 'Enter text used as title of plan.', 'yolo-kidzone' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Price', 'yolo-kidzone' ),
			'param_name' => 'price',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Link', 'yolo-kidzone' ),
			'param_name' => 'link',
			'description' => esc_html__( 'Enter link of plan.', 'yolo-kidzone' ),
		),
		array(
			'type' => 'param_group',
			'heading' => esc_html__( 'Values', 'yolo-kidzone' ),
			'param_name' => 'values',
			'description' => esc_html__( 'Enter values for pricing plan - price, title and etc...', 'yolo-kidzone' ),
			'value' => urlencode( json_encode( array(
				array(
					'label' => esc_html__( 'Content 1', 'yolo-kidzone' ),
					'value' => '',
				),
				array(
					'label' => esc_html__( 'Content 2', 'yolo-kidzone' ),
					'value' => '',
				),
				array(
					'label' => esc_html__( 'Content 3', 'yolo-kidzone' ),
					'value' => '',
				),
			) ) ),
			'params' => array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Label', 'yolo-kidzone' ),
					'param_name' => 'label',
					'description' => esc_html__( 'Enter text used as value of Label.', 'yolo-kidzone' ),
					'admin_label' => true,
				),
			),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Height (px)', 'yolo-kidzone' ),
			'param_name' => 'height',
			'description' => esc_html__( 'Enter height of plan (insert number only). Default is 617px', 'yolo-kidzone' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'yolo-kidzone' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'yolo-kidzone' ),
		),
	),
) );


/* [yolo_courses] */
vc_map( array(
	'name'			=> esc_html__( 'Yolo Courses', 'yolo-kidzone' ),
	'base'			=> 'yolo_courses',
	'category'		=> $category_name,
	'description'	=> esc_html__( 'Display courses', 'yolo-kidzone' ),
	'params'		=> array(
			array(
				'param_name' 	=> 'courses',
				'heading'		=> esc_html__( 'Select categories', 'yolo-kidzone' ),
				'description'	=> esc_html__( 'Select courses categories', 'yolo-kidzone' ),
				'type'			=> 'courses',
				'std'   		=> 'all'
			),
			array(
				'param_name'  	=> 'style',
				'heading'     	=> esc_html__( 'Style', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'dropdown',
				'std'			=> 'grid',
				'value'       	=> array(
					esc_html__( 'Grid', 'yolo-kidzone' )    	=>  'grid',
					esc_html__( 'List', 'yolo-kidzone' )  	    =>  'list'
				)	
			),
			array(
				'param_name'  	=> 'columns',
				'heading'     	=> esc_html__( 'Grid Columns', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'dropdown',
				'std'			=> 2,
				'value'       	=> array(
					esc_html__( 'Two', 'yolo-kidzone' )    	=>  2,
					esc_html__( 'Three', 'yolo-kidzone' )  	=>  3,
					esc_html__( 'Four', 'yolo-kidzone' )  	=>  4
					),
				'dependency' => array( 'element' => 'style', 'value' => array( 'grid' ) )
				),
			array(
				'param_name' 	=> 'posts_per_page',
				'heading'		=> esc_html__( 'Posts Per Page', 'yolo-kidzone' ),
				'type'			=> 'textfield',
				'value'			=> ''
			),
			array(
				'param_name'  	=> 'pagination',
				'heading'     	=> esc_html__( 'Show Pagination', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'dropdown',
				'std'			=> 'hide',
				'value'       	=> array(
					esc_html__( 'Hide', 'yolo-kidzone' )  	=>  'hide',
					esc_html__( 'Show', 'yolo-kidzone' )  	=>  'show'
					)
				),
			array( 
				'param_name' => 'excerpt_length', 
				'heading' => esc_html__( 'Excerpt length', 'yolo-kidzone' ), 
				'type' => 'textfield', 
				'std' => 55, 
			),
			array(
				'param_name'  	=> 'class',
				'heading'     	=> esc_html__( 'Class', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'textfield',
				'value'       	=> ''
				)
		)
	) 
);

/* [yolo_teachers] */
vc_map( array(
	'name'			=> esc_html__( 'Yolo Teachers', 'yolo-kidzone' ),
	'base'			=> 'yolo_teachers',
	'category'		=> $category_name,
	'description'	=> esc_html__( 'Display teachers', 'yolo-kidzone' ),
	'params'		=> array(

			array(
				'param_name'  	=> 'style',
				'heading'     	=> esc_html__( 'Style', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'dropdown',
				'std'			=> 'grid',
				'value'       	=> array(
					esc_html__( 'Home 1', 'yolo-kidzone' )  =>  'index-1',
					esc_html__( 'Home 2', 'yolo-kidzone' )  =>  'index-2',
					esc_html__( 'Grid', 'yolo-kidzone' )    	  =>  'grid',
					esc_html__( 'List', 'yolo-kidzone' )  	      =>  'list'
				)
			),
			array(
				'param_name' 	=> 'teachers',
				'heading'		=> esc_html__( 'Select categories', 'yolo-kidzone' ),
				'description'	=> esc_html__( 'Select teachers categories', 'yolo-kidzone' ),
				'type'			=> 'teachers',
				'std'   		=> 'all'
			),
			array(
				'param_name'  	=> 'columns',
				'heading'     	=> esc_html__( 'Grid Columns', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'dropdown',
				'std'			=> 2,
				'value'       	=> array(
					esc_html__( 'Two', 'yolo-kidzone' )    	=>  2,
					esc_html__( 'Three', 'yolo-kidzone' )  	=>  3,
					esc_html__( 'Four', 'yolo-kidzone' )  	=>  4
					),
				'dependency' => array( 'element' => 'style', 'value' => array( 'grid','index-2','index-1' ) )
				),
			array(
				'param_name' 	=> 'posts_per_page',
				'heading'		=> esc_html__( 'Posts Per Page', 'yolo-kidzone' ),
				'type'			=> 'textfield',
				'value'			=> ''
			),
			array(
				'param_name'  	=> 'pagination',
				'heading'     	=> esc_html__( 'Show Pagination', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'dropdown',
				'std'			=> 'hide',
				'value'       	=> array(
					esc_html__( 'Hide', 'yolo-kidzone' )  	=>  'hide',
					esc_html__( 'Show', 'yolo-kidzone' )  	=>  'show'
					)
				),
			array(
				'param_name'  	=> 'read_more',
				'heading'     	=> esc_html__( 'Show Readmore', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'checkbox',
				'std'			=> true	
				),
			array( 
				'param_name' => 'excerpt_length', 
				'heading' => esc_html__( 'Excerpt length', 'yolo-kidzone' ), 
				'type' => 'textfield', 
				'std' => 55, 
				),
			array(
				'param_name'  	=> 'class',
				'heading'     	=> esc_html__( 'Class', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'textfield',
				'value'       	=> ''
				)
		)
	) );

/* [yolo_events] */
$taxonomies = array( 
        'event_category',
    );
    $args = array(
        'hide_empty' => 1,
        'orderby'    => 'ASC'
    );
    $event_categories = get_terms( $taxonomies, $args );
    $event_cat        = array();
    if ( is_array($event_categories) ) {
        foreach ( $event_categories as $cat ) {
            $event_cat[$cat->name] = $cat->slug;
        }
    }

    $args = array(
        'posts_per_page' => -1,
        'post_type'      => 'event',
        'post_status'    => 'publish'
    );
    $list_event = array();
    $post_array   = get_posts($args);
    foreach ($post_array as $post) : setup_postdata($post);
        $list_event[$post->post_title] = $post->ID;
    endforeach;
    wp_reset_postdata();

vc_map( array(
	'name'			=> esc_html__( 'Yolo Events', 'yolo-kidzone' ),
	'base'			=> 'yolo_events',
	'category'		=> $category_name,
	'description'	=> esc_html__( 'Display events', 'yolo-kidzone' ),
	'params'		=> array(
			array(
	                'type'        => 'dropdown',
	                'heading'     => esc_html__( 'Source', 'yolo-kidzone' ),
	                'param_name'  => 'data_source',
	                'value'       => array(
	                    esc_html__( 'From Category', 'yolo-kidzone' )    => 'event_cat',
	                    esc_html__( 'From Event IDs', 'yolo-kidzone' ) => 'event_list_id'
	                )
	            ),

	            array(
	                'type'        => 'event_categories',
	                'heading'     => esc_html__( 'Select Category', 'yolo-kidzone' ),
	                'param_name'  => 'category',
	                'dependency'  => Array(
	                    'element' => 'data_source',
	                    'value'   => array('event_cat')
	                ),
	            ),

 				array(
	            	'type'        	=> 'events',
	                'heading'    => esc_html__( 'Select Event', 'yolo-kidzone' ),
	                'param_name' => 'event_ids',
	                'dependency' => Array(
	                    'element' => 'data_source', 
	                    'value'   => array('event_list_id')
	                )
	            ),

			array(
				'param_name'  	=> 'style',
				'heading'     	=> esc_html__( 'Style', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'dropdown',
				'std'			=> 'grid',
				'value'       	=> array(
					esc_html__( 'Grid', 'yolo-kidzone' )    	=>  'grid',
					esc_html__( 'List', 'yolo-kidzone' )  	    =>  'list'
				)
			),
			array(
				'param_name'  	=> 'columns',
				'heading'     	=> esc_html__( 'Grid Columns', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'dropdown',
				'std'			=> 2,
				'value'       	=> array(
					esc_html__( 'Two', 'yolo-kidzone' )    	=>  2,
					esc_html__( 'Three', 'yolo-kidzone' )  	=>  3,
					esc_html__( 'Four', 'yolo-kidzone' )  	=>  4
					),
				'dependency' => array( 'element' => 'style', 'value' => array( 'grid' ) )
				),
			array(
				'param_name' 	=> 'posts_per_page',
				'heading'		=> esc_html__( 'Posts Per Page', 'yolo-kidzone' ),
				'type'			=> 'textfield',
				'value'			=> ''
			),
			array(
				'param_name'  	=> 'pagination',
				'heading'     	=> esc_html__( 'Show Pagination', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'dropdown',
				'std'			=> 'hide',
				'value'       	=> array(
					esc_html__( 'Hide', 'yolo-kidzone' )  	=>  'hide',
					esc_html__( 'Show', 'yolo-kidzone' )  	=>  'show'
					)
				),
			array( 
				'param_name' => 'excerpt_length', 
				'heading' => esc_html__( 'Excerpt length', 'yolo-kidzone' ), 
				'type' => 'textfield', 
				'std' => 55, 
				),
			array(
				'param_name'  	=> 'class',
				'heading'     	=> esc_html__( 'Class', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'textfield',
				'value'       	=> ''
				)
		)
	) );

/* [yolo_portfolio] */
vc_map( array(
	'name'			=> esc_html__( 'Yolo Portfolio', 'yolo-kidzone' ),
	'base'			=> 'yolo_portfolio',
	'category'		=> $category_name,
	'description'	=> esc_html__( 'Display portfolio', 'yolo-kidzone' ),
	'params'		=> array(

			array(
				'param_name'  	=> 'hover_effect',
				'heading'     	=> esc_html__( 'Style Effect', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'dropdown',
				'std'			=> 'effect1',
				'value'       	=> array(
					esc_html__( 'Home 1', 'yolo-kidzone' )    	=>  'effect1',
					esc_html__( 'Home 2', 'yolo-kidzone' )  	=>  'effect2'
				)
			),
			array(
				'param_name' 	=> 'portfolio',
				'heading'		=> esc_html__( 'Select categories', 'yolo-kidzone' ),
				'description'	=> esc_html__( 'Select portfolio categories', 'yolo-kidzone' ),
				'type'			=> 'portfolio',

			),
			array(
				'param_name'  	=> 'columns',
				'heading'     	=> esc_html__( 'Grid Columns', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'dropdown',
				'std'			=> 2,
				'value'       	=> array(
					esc_html__( 'Two', 'yolo-kidzone' )    	=>  2,
					esc_html__( 'Three', 'yolo-kidzone' )  	=>  3,
					esc_html__( 'Four', 'yolo-kidzone' )  	=>  4
					)
				),
			array(
				'param_name' 	=> 'posts_per_page',
				'heading'		=> esc_html__( 'Posts Per Page', 'yolo-kidzone' ),
				'type'			=> 'textfield',
				'value'			=> ''
			),
			array( 
				'param_name' => 'portfolio_filter', 
				'heading' => esc_html__( 'Show filter', 'yolo-kidzone' ), 
				'type' => 'checkbox', 
				'value' => array( '' => 'true' ) ),
			array( 
				'param_name' => 'show_all_tab', 
				'heading' => esc_html__( 'Show All Tab', 'yolo-kidzone' ), 
				'type' => 'checkbox', 
				'value' => array( '' => 'false' ) ,
				'dependency' => array( 'element' => 'portfolio_filter', 'value' => array( 'true' ) )
				),
			array(
				'param_name'	=> 'filterbar_position',
				'heading'		=> esc_html__('Filterbar Position','yolo-kidzone'),
				'type'			=> 'dropdown',
				'value'			=> array(
					esc_html__('Left','yolo-kidzone')	=> 'left',
					esc_html__('Center','yolo-kidzone') => 'center',
					esc_html__('Right','yolo-kidzone')	=> 'right'
					),
				'std'			=> 'left',
				'dependency' => array( 'element' => 'portfolio_filter', 'value' => array( 'true' ) ) ),
			array(
				'param_name'  	=> 'pagination',
				'heading'     	=> esc_html__( 'Show Load More', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'dropdown',
				'value'       	=> array(
					esc_html__( 'Show', 'yolo-kidzone' )  	=>  'show',
					esc_html__( 'Hide', 'yolo-kidzone' )  	=>  'hide'
					)
				),
			array(
				'param_name'  	=> 'class',
				'heading'     	=> esc_html__( 'Class', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'textfield',
				'value'       	=> ''
				)
		)
	) );

/* [yolo_timetable] */
vc_map( array(
	'name'			=> esc_html__( 'Yolo TimeTable', 'yolo-kidzone' ),
	'base'			=> 'yolo_timetable',
	'category'		=> $category_name,
	'description'	=> esc_html__( 'Display Courses TimeTable', 'yolo-kidzone' ),
	'params'		=> array(
			array(
				'param_name'    =>  'title',
				'type'          =>  'textfield',
				'heading'       =>  esc_html__('Title','yolo-kidzone'),
				'value'         =>  ''
				),
			array(
				'param_name' 	=> 'courses',
				'heading'		=> esc_html__( 'Select categories', 'yolo-kidzone' ),
				'description'	=> esc_html__( 'Select courses categories', 'yolo-kidzone' ),
				'type'			=> 'courses',
				'std'   		=> 'all'
			),
			array(
				'param_name'  	=> 'show_filter',
				'heading'     	=> esc_html__( 'Show Filter', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'checkbox',
				'value' 		=> array( '' => 'true' )

				),
			array(
				'param_name'  	=> 'filter',
				'heading'     	=> esc_html__( 'Filter Style', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'dropdown',
				'std'			=> 'button',
				'value'       	=> array(
					esc_html__( 'Button', 'yolo-kidzone' )  =>  'button',
					esc_html__( 'List', 'yolo-kidzone' )  	=>  'list'
					),
				'dependency' => array( 'element' => "show_filter", 'value' => array( 'true' ) ),
				),
			array(
				'param_name'  	=> 'filter_position',
				'heading'     	=> esc_html__( 'Filter Position', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'dropdown',
				'std'			=> 'left',
				'value'       	=> array(
					esc_html__( 'Left', 'yolo-kidzone' )  =>  'filter-left',
					esc_html__( 'Center', 'yolo-kidzone' )  	=>  'filter-center',
					esc_html__( 'Right', 'yolo-kidzone' )  	=>  'filter-right',
					),
				'dependency' => array( 'element' => "show_filter", 'value' => array( 'true' ) ),
				),
			array(
				'param_name'  	=> 'class',
				'heading'     	=> esc_html__( 'Class', 'yolo-kidzone' ),
				'description' 	=> '',
				'type'        	=> 'textfield',
				'value'       	=> ''
				)
		)
	) );

// [yolo_statistical]
vc_map(array(
	"name" => esc_html__("Yolo Statistical", 'yolo-kidzone'),
	"base" => "yolo_statistical",
	"category" => $category_name,
	'description' => esc_html__( 'Display Statistical', 'yolo-kidzone' ),
	'params'    =>  array(
		array(
			'param_name'  	=> 'style',
			'heading'     	=> esc_html__( 'Style', 'yolo-kidzone' ),
			'description' 	=> '',
			'type'        	=> 'dropdown',
			'std'			=> 'index-1',
			'value'       	=> array(
				esc_html__( 'Home 1 (Have description)', 'yolo-kidzone' )    	=>  'index-1',
				esc_html__( 'Home 2 (Not description)', 'yolo-kidzone' )  	=>  'index-2',
				)
			),
		array(
			'type'          =>  'textfield',
			'class'         =>  'title',
			'heading'       =>  esc_html__('Title','yolo-kidzone'),
			'param_name'    =>  'title',
			'value'         =>  ''
			),
		array(
			'type'          =>  'textfield',
			'class'         =>  'number',
			'heading'       =>  esc_html__('Number','yolo-kidzone'),
			'param_name'    =>  'number',
			'value'         =>  ''
			),
		array(
			'param_name'    =>  'font_icon',
			'heading'       =>  esc_html__('Choose icon', 'yolo-kidzone'),
			'description'   =>  '',
			'type'          =>  'iconpicker',
			'value'       	=> '',
			'dependency' => array( 'element' => 'style', 'value' =>array( 'index-1'))
			),
		array(
			'param_name'    =>  'color',
			'heading'       =>  esc_html__('Choose color', 'yolo-kidzone'),
			'description'   =>  '',
			'type'          =>  'colorpicker',
			'value'       => ''
			),

		)
	));

// [yolo_video]
vc_map(array(
	"name" => esc_html__("Yolo Video", 'yolo-kidzone'),
	"base" => "yolo_video",
	"category" => $category_name,
	'description' => esc_html__( 'Display Video', 'yolo-kidzone' ),
	'params'    =>  array(
		array(
			'param_name'  => 'style',
			'heading'     => esc_html__( 'Choose style for video', 'yolo-kidzone' ),
			'description' => '',
			'type'        => 'dropdown',
			'value'       => array(
				esc_html__( 'Home 1', 'yolo-kidzone' )   => 'index-1',
				esc_html__( 'Home 2', 'yolo-kidzone' )   => 'index-2'
				)
			),
	
		array(
			'type'          =>  'textfield',
			'heading'       =>  esc_html__('Video URL','yolo-kidzone'),
			'param_name'    =>  'video_url',
			'value'         =>  '',
			),
		
		array(
			'param_name'  => 'featured_image',
			'heading'     => esc_html__( 'Background Image Video', 'yolo-kidzone' ),
			'description' => '',
			'type'        => 'attach_image',
			'value'       => '',
			),
		)
	));
// Yolo Search Post Type
vc_map(array(
	'name' => __('Yolo search post type', 'yolo-kidzone'),
	'base' => 'yolo_search_post',
	'category' => $category_name,
	'name' => esc_html__('Yolo search post type', 'yolo-kidzone'),
	'category' => $category_name,
	'description' => esc_html__( 'Display post following pos type(teacher, course, event, product)', 'yolo-kidzone' ),
	'params'    =>  array(
		array(
			'param_name'  => 'post_type',
			'heading'     => esc_html__( 'Option Post Type', 'yolo-kidzone' ),
			'description' => '',
			'type'        => 'dropdown',
			'value'       => array(
				esc_html__( 'Product', 'yolo-kidzone' )   	=> 'product',
				esc_html__( 'Courses', 'yolo-kidzone' )   	=> 'course',
				esc_html__( 'Teachers', 'yolo-kidzone' )   	=> 'teacher',
				esc_html__( 'Event', 'yolo-kidzone' )   	=> 'event'
			),
		),
	)
));