<?php
if ( function_exists( 'vc_set_as_theme' ) ) :
    vc_set_as_theme( true );

endif;

// Disable Frontend Editor
// http://kb.wpbakery.com/index.php?title=Vc_disable_frontend

// if ( function_exists( 'vc_disable_frontend' ) ) :
//     vc_disable_frontend();

// endif;

if ( defined( 'WPB_VC_VERSION' ) ) :

    function yolo_dropdown_group_param( $param, $param_value ) {
        $css_option = vc_get_dropdown_option( $param, $param_value );
        $param_line = '';
        $param_line .= '<select name="' . $param['param_name'] .
            '" class="dh-chosen-select wpb_vc_param_value wpb-input wpb-select ' . $param['param_name'] . ' ' .
            $param['type'] . ' ' . $css_option . '" data-option="' . $css_option . '">';
        foreach ( $param['optgroup'] as $text_opt => $opt ) {
            if ( is_array( $opt ) ) {
                $param_line .= '<optgroup label="' . $text_opt . '">';
                foreach ( $opt as $text_val => $val ) {
                    if ( is_numeric( $text_val ) && ( is_string( $val ) || is_numeric( $val ) ) ) {
                        $text_val = $val;
                    }
                    $selected = '';
                    if ( $param_value !== '' && (string) $val === (string) $param_value ) {
                        $selected = ' selected="selected"';
                    }
                    $param_line .= '<option class="' . $val . '" value="' . $val . '"' . $selected . '>' .
                        htmlspecialchars( $text_val ) . '</option>';
                }
                $param_line .= '</optgroup>';
            } elseif ( is_string( $opt ) ) {
                if ( is_numeric( $text_opt ) && ( is_string( $opt ) || is_numeric( $opt ) ) ) {
                    $text_opt = $opt;
                }
                $selected = '';
                if ( $param_value !== '' && (string) $opt === (string) $param_value ) {
                    $selected = ' selected="selected"';
                }
                $param_line .= '<option class="' . $opt . '" value="' . $opt . '"' . $selected . '>' .
                    htmlspecialchars( $text_opt ) . '</option>';
            }
        }
        $param_line .= '</select>';
        return $param_line;
    }
    vc_add_shortcode_param( 'yolo_dropdown_group', 'yolo_dropdown_group_param' );

    // Categories select field type
    if ( ! function_exists( 'yolo_vc_field_type_post_categories' ) ) :

        function yolo_vc_custom_param_post_categories( $settings, $value ) {
            //$dependency = vc_generate_dependencies_attributes( $settings );
            $categories = get_categories( array( 'orderby' => 'NAME', 'order' => 'ASC' ) );
            $class = 'wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '_field';
            $selected_values = explode( ',', $value );
            $html = array( '<div class="yolo_vc_custom_param post_categories">' );
            $html[] = '  <input type="hidden" name="' . $settings['param_name'] . '" value="' . $value .
                '" class="wpb_vc_param_value" />';
            $html[] = '  <select name="' . $settings['param_name'] . '-select" multiple="true" class="' . $class . '">';
            $html[] = '    <option value="all" ' . ( in_array( 'all', $selected_values ) ? 'selected="true"' : '' ) . '>' .
                __( 'All', 'yolo-kidzone' ) . '</option>';
            foreach ( $categories as $category ) {
                $html[] = '    <option value="' . $category->term_id . '" ' .
                    ( in_array( $category->term_id, $selected_values ) ? 'selected="true"' : '' ) . '>';
                $html[] = '      ' . $category->name;
                $html[] = '    </option>';
            }

            $html[] = '  </select>';
            $html[] = '</div>';
            $html[] = '<script>';
            $html[] = '  jQuery("document").ready( function() {';
            $html[] = '	   jQuery( "select[name=\'' . $settings['param_name'] . '-select\']" ).click( function() {';
            $html[] = '      var selected_values = jQuery(this).find("option:selected").map(function(){ return this.value; }).get().join(",");';
            $html[] = '      jQuery( "input[name=\'' . $settings['param_name'] . '\']" ).val( selected_values );';
            $html[] = '	   } );';
            $html[] = '  } );';
            $html[] = '</script>';

            return implode( "\n", $html );
        }
        vc_add_shortcode_param( 'post_categories', 'yolo_vc_custom_param_post_categories' );


    endif;// Categories select field type
    //
    //
    //// Categories select field type
    if ( ! function_exists( 'yolo_vc_field_type_post_event_categories' ) ) :

        function yolo_vc_field_type_post_event_categories( $settings, $value ) {
            $categories      = get_terms( 'event_category', array( 'orderby' => 'NAME', 'order' => 'ASC' ) );
            $class = 'wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '_field';
            $selected_values = explode( ',', $value );
            $html = array( '<div class="yolo_vc_custom_param post_categories">' );
            $html[] = '  <input type="hidden" name="' . $settings['param_name'] . '" value="' . $value .
                 '" class="wpb_vc_param_value" />';
            $html[] = '  <select name="' . $settings['param_name'] . '-select" multiple="true" class="' . $class . '">';
            $html[] = '    <option value="all" ' . ( in_array( 'all', $selected_values ) ? 'selected="true"' : '' ) . '>' .
                 __( 'All', 'yolo-kidzone' ) . '</option>';
            foreach ( $categories as $category ) {
                $html[] = '    <option value="' . $category->term_id . '" ' .
                     ( in_array( $category->term_id, $selected_values ) ? 'selected="true"' : '' ) . '>';
                $html[] = '      ' . $category->name;
                $html[] = '    </option>';
            }
            
            $html[] = '  </select>';
            $html[] = '</div>';
            $html[] = '<script>';
            $html[] = '  jQuery("document").ready( function() {';
            $html[] = '    jQuery( "select[name=\'' . $settings['param_name'] . '-select\']" ).click( function() {';
            $html[] = '      var selected_values = jQuery(this).find("option:selected").map(function(){ return this.value; }).get().join(",");';
            $html[] = '      jQuery( "input[name=\'' . $settings['param_name'] . '\']" ).val( selected_values );';
            $html[] = '    } );';
            $html[] = '  } );';
            $html[] = '</script>';
            
            return implode( "\n", $html );
        }
        vc_add_shortcode_param( 'event_categories', 'yolo_vc_field_type_post_event_categories' );


    endif;// Categories select field type


    // Categories select field type
    if ( ! function_exists( 'yolo_vc_field_type_post_tags' ) ) :

        function yolo_vc_field_type_post_tags( $settings, $value ) {
            //$dependency = vc_generate_dependencies_attributes( $settings );
            $categories = get_tags( array( 'orderby' => 'NAME', 'order' => 'ASC' ) );
            $class = 'wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '_field';
            $selected_values = explode( ',', $value );
            $html = array( '<div class="yolo_vc_custom_param post_categories">' );
            $html[] = '  <input type="hidden" name="' . $settings['param_name'] . '" value="' . $value .
                '" class="wpb_vc_param_value" />';
            $html[] = '  <select name="' . $settings['param_name'] . '-select" multiple="true" class="' . $class . '" >';
            $html[] = '    <option value="all" ' . ( in_array( 'all', $selected_values ) ? 'selected="true"' : '' ) . '>' .
                __( 'All', 'yolo-kidzone' ) . '</option>';
            foreach ( $categories as $category ) {
                $html[] = '    <option value="' . $category->term_id . '" ' .
                    ( in_array( $category->term_id, $selected_values ) ? 'selected="true"' : '' ) . '>';
                $html[] = '      ' . $category->name;
                $html[] = '    </option>';
            }

            $html[] = '  </select>';
            $html[] = '</div>';
            $html[] = '<script>';
            $html[] = '  jQuery("document").ready( function() {';
            $html[] = '	   jQuery( "select[name=\'' . $settings['param_name'] . '-select\']" ).click( function() {';
            $html[] = '      var selected_values = jQuery(this).find("option:selected").map(function(){ return this.value; }).get().join(",");';
            $html[] = '      jQuery( "input[name=\'' . $settings['param_name'] . '\']" ).val( selected_values );';
            $html[] = '	   } );';
            $html[] = '  } );';
            $html[] = '</script>';

            return implode( "\n", $html );
        }
        vc_add_shortcode_param( 'post_tags', 'yolo_vc_field_type_post_tags' );


    endif;// Categories select field type


    if ( ! function_exists( 'yolo_vc_custom_param_user_list' ) ) :

        function yolo_vc_custom_param_user_list( $settings, $value ) {
            //$dependency = vc_generate_dependencies_attributes( $settings );
            $users = get_users( array( 'orderby' => 'NAME', 'order' => 'ASC' ) );
            $class = 'wpb_vc_param_value wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] .
                '_field';
            $html = array( '<div class="yolo_vc_custom_param user_list">' );
            // $html[] = ' <input type="hidden" name="'. $settings['param_name'] . '" value="'. $value . '"
            // class="wpb_vc_param_value" />';
            $html[] = '  <select name="' . $settings['param_name'] . '" class="' . $class . '" >';
            foreach ( $users as $user ) {
                $html[] = '    <option value="' . $user->ID . '" ' . ( selected( $value, $user->ID, false ) ) . '>';
                $html[] = '      ' . $user->display_name;
                $html[] = '    </option>';
            }

            $html[] = '  </select>';
            $html[] = '</div>';

            return implode( "\n", $html );
        }
        vc_add_shortcode_param( 'user_list', 'yolo_vc_custom_param_user_list' );


    endif;

    if ( ! function_exists( 'yolo_vc_custom_param_project_categories' ) ) :

        function yolo_vc_custom_param_project_categories( $settings, $value ) {
            //$dependency = vc_generate_dependencies_attributes( $settings );
            $categories = get_terms( 'portfolio_category', array( 'orderby' => 'NAME', 'order' => 'ASC' ) );
            $class = 'wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '_field';
            $selected_values = explode( ',', $value );
            $html = array( '<div class="yolo_vc_custom_param project_categories">' );
            $html[] = '  <input type="hidden" name="' . $settings['param_name'] . '" value="' . $value .
                '" class="wpb_vc_param_value" />';
            $html[] = '  <select name="' . $settings['param_name'] . '-select" multiple="true" class="' . $class . '">';
            $html[] = '    <option value="all" ' . ( in_array( 'all', $selected_values ) ? 'selected="true"' : '' ) . '>' .
                __( 'All', 'yolo-kidzone' ) . '</option>';
            foreach ( $categories as $category ) {
                $html[] = '    <option value="' . $category->term_id . '" ' .
                    ( in_array( $category->term_id, $selected_values ) ? 'selected="true"' : '' ) . '>';
                $html[] = '      ' . $category->name;
                $html[] = '    </option>';
            }

            $html[] = '  </select>';
            $html[] = '</div>';
            $html[] = '<script>';
            $html[] = '  jQuery("document").ready( function() {';
            $html[] = '	   jQuery( "select[name=\'' . $settings['param_name'] . '-select\']" ).click( function() {';
            $html[] = '      var selected_values = jQuery(this).find("option:selected").map(function(){ return this.value; }).get().join(",");';
            $html[] = '      jQuery( "input[name=\'' . $settings['param_name'] . '\']" ).val( selected_values );';
            $html[] = '	   } );';
            $html[] = '  } );';
            $html[] = '</script>';

            return implode( "\n", $html );
        }
        vc_add_shortcode_param( 'project_categories', 'yolo_vc_custom_param_project_categories' );

    endif;


    if ( class_exists( 'RevSlider' ) ) {
        if ( ! function_exists( 'yolo_vc_rev_slider' ) ) :

            function yolo_vc_rev_slider( $settings, $value ) {
                //$dependency = vc_generate_dependencies_attributes( $settings );
                $rev_slider = new RevSlider();
                $sliders = $rev_slider->getArrSliders();
                $class = 'wpb_vc_param_value wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] .
                    '_field';
                $html = array( '<div class="yolo_vc_custom_param yolo_rev_slider">' );
                $html[] = '  <select name="' . $settings['param_name'] . '" class="' . $class . '" >';
                foreach ( $sliders as $slider ) {
                    $html[] = '    <option value="' . $slider->getAlias() . '"' .
                        ( selected( $value, $slider->getAlias() ) ) . '>' . $slider->getTitle() . '</option>';
                }
                $html[] = '  </select>';
                $html[] = '</div>';

                return implode( "\n", $html );
            }

            vc_add_shortcode_param( 'yolo_rev_slider', 'yolo_vc_rev_slider' );


        endif;
    }

    if ( ! function_exists( 'yolo_vc_custom_param_ui_slider' ) ) :

        function yolo_vc_custom_param_ui_slider( $settings, $value ) {
            //$dependency = vc_generate_dependencies_attributes( $settings );
            $class = 'yolo-slider wpb_vc_param_value wpb-input wpb-select ' . $settings['param_name'] . ' ' .
                $settings['type'] . '_field';
            $data_min = ( isset( $settings['data_min'] ) && ! empty( $settings['data_min'] ) ) ? 'data-min="' .
                $settings['data_min'] . '"' : 'data-min="0"';
            $data_max = ( isset( $settings['data_max'] ) && ! empty( $settings['data_max'] ) ) ? 'data-max="' .
                $settings['data_max'] . '"' : 'data-max="100"';
            $data_step = ( isset( $settings['data_step'] ) && ! empty( $settings['data_step'] ) ) ? 'data-step="' .
                $settings['data_step'] . '"' : 'data-step="1"';
            $html = array();

            $html[] = '	<div class="yolo-control">';
            $html[] = '		<input type="text" id="' . $settings['param_name'] . '" name="' . $settings['param_name'] .
                '" class="' . $class . '" value="' . $value . '" ' . $data_min . ' ' . $data_max . ' ' . $data_step .
                '/>';
            $html[] = '	</div>';
            $html[] = '<script>';
            $html[] = 'jQuery("#' . $settings['param_name'] . '").each(function() {';
            $html[] = '	var $this = jQuery(this);';
            $html[] = '	var $slider = jQuery("<div>", {id: $this.attr("id") + "-slider"}).insertAfter($this);';
            $html[] = '	$slider.slider(';
            $html[] = '	{';
            $html[] = '		range: "min",';
            $html[] = '		value: $this.val() || $this.data("min") || 0,';
            $html[] = '		min: $this.data("min") || 0,';
            $html[] = '		max: $this.data("max") || 100,';
            $html[] = '		step: $this.data("step") || 1,';
            $html[] = '		slide: function(event, ui) {';
            $html[] = '			$this.val(ui.value).attr("value", ui.value);';
            $html[] = '		}';
            $html[] = '	}';
            $html[] = '	);';
            $html[] = '	$this.change(function() {';
            $html[] = '		$slider.slider( "option", "value", $this.val() );';
            $html[] = '	});';
            $html[] = '});';
            $html[] = '</script>';

            return implode( "\n", $html );
        }

        vc_add_shortcode_param( 'ui_slider', 'yolo_vc_custom_param_ui_slider' );

    endif;

    /* Add type testimonial*/
    if ( !function_exists('yolo_vc_custom_param_testimonials') ) :

        function yolo_vc_custom_param_testimonials($settings, $value)
        {
            //$dependency = vc_generate_dependencies_attributes($settings);
            $class = 'wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '_field';
            $selected_values = explode(',', $value);
            
            $args = array(
                'post_type'     => 'testimonial',
                'post_status'   => 'publish',
                'numberposts'   => '-1'
            );
            $testimonials = get_posts($args);

            $html[] = '<div class="yolo_vc_custom_param testimonial">';
            $html[] = '  <input type="hidden" name="' . $settings['param_name'] . '" value="' . $value .
                '" class="wpb_vc_param_value" />';
            $html[] = '  <select name="' . $settings['param_name'] . '-select" multiple="true" class="' . $class . '">';

            if($value == 'all'){
                $html[] = '<option class="yl-all" value="all" style="background: #ddd;">' . __('All', 'yolo-kidzone') . '</option>';
            } else {
                $html[] = '<option class="yl-all" value="all" >' . __('All', 'yolo-kidzone') . '</option>';
            }

            foreach( $testimonials as $key => $testimonials ){
                if(in_array($testimonials->ID, $selected_values)){
                    $html[] = '<option value="'.$testimonials->ID.'" style="background: #ddd;" >'. $testimonials->post_title .'</option>';
                } else {
                    $html[] = '<option value="'.$testimonials->ID.'" >'. $testimonials->post_title .'</option>';
                }
            }
            $html[] = '</select>';
            $html[] = '</div>';

            $html[] = '<script>';
            $html[] = '  jQuery("document").ready( function() {';
            $html[] = '    jQuery("input[name=\'thumbitem\']").keyup(function(){ ';
            $html[] = '         var ylthumbitem = jQuery("input[name=\'thumbitem\']").val();';
            $html[] = '             if(isNaN(parseInt(ylthumbitem))) {';
            $html[] = '                 jQuery("input[name=\'thumbitem\']").val("");';
            $html[] = '             } else {';
            $html[] = '                 jQuery("input[name=\'thumbitem\']").val(parseInt(ylthumbitem));';
            $html[] = '             }';
            $html[] = '    } );';
            $html[] = '	   jQuery( "select[name=\'' . $settings['param_name'] . '-select\']" ).click( function() {';
            $html[] = '         jQuery( "select[name=\'' . $settings['param_name'] . '-select\'] option" ).removeAttr("style")';
            $html[] = '         var selected_values = jQuery(this).find("option:selected").map(function(){ return this.value; }).get().join(",");';
            $html[] = '         if( selected_values.indexOf("all") >= 0){';
            $html[] = '             selected_values = "all";';
            $html[] = '         }';
            $html[] = '      jQuery( "input[name=\'' . $settings['param_name'] . '\']" ).val( selected_values );';
            $html[] = '	   } );';
            $html[] = '  } );';
            $html[] = '</script>';

            return  implode("\n", $html);
        }

        vc_add_shortcode_param('yl_testimonials', 'yolo_vc_custom_param_testimonials');

    endif;

    /* Add type lookbook*/
    if (!function_exists('yolo_vc_field_type_lookbooks')) :

        function yolo_vc_custom_param_lookbooks($settings, $value)
        {
            //$dependency = vc_generate_dependencies_attributes($settings);

            $categories = get_terms('product_lookbook');
            $class = 'wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '_field';
            $selected_values = explode(',', $value);
            
            $html = array('<div class="yolo_vc_custom_param post_categories">');
            $html[] = '  <input type="hidden" name="' . $settings['param_name'] . '" value="' . $value .
                '" class="wpb_vc_param_value" />';
            $html[] = '  <select name="' . $settings['param_name'] . '-select" multiple="true" class="' . $class . '">';
            $html[] = '    <option value="all" ' . (in_array('all', $selected_values) ? 'selected="true"' : '') . '>' .
                __('All', 'yolo-kidzone') . '</option>';
            foreach ($categories as $category) {
                $html[] = '    <option value="' . $category->term_id . '" ' .
                    (in_array($category->term_id, $selected_values) ? 'selected="true"' : '') . '>';
                $html[] = '      ' . $category->name;
                $html[] = '    </option>';
            }

            $html[] = '  </select>';
            $html[] = '</div>';
            $html[] = '<script>';
            $html[] = '  jQuery("document").ready( function() {';
            $html[] = '	   jQuery( "select[name=\'' . $settings['param_name'] . '-select\']" ).click( function() {';
            $html[] = '      var selected_values = jQuery(this).find("option:selected").map(function(){ return this.value; }).get().join(",");';
            $html[] = '      jQuery( "input[name=\'' . $settings['param_name'] . '\']" ).val( selected_values );';
            $html[] = '	   } );';
            $html[] = '  } );';
            $html[] = '</script>';

            return implode("\n", $html);
        }

        vc_add_shortcode_param('lookbooks', 'yolo_vc_custom_param_lookbooks');
    endif;

    //Product Category
    if ( ! function_exists( 'yolo_vc_field_type_yol_category' ) ) :

        function yolo_vc_custom_param_product_category( $settings, $value ) {
            //$dependency = vc_generate_dependencies_attributes( $settings );
            $categories = get_terms( 'product_cat', array( 'orderby' => 'NAME', 'order' => 'ASC' ) );
            $class = 'wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '_field';
            $selected_values = explode( ',', $value );
            $html = array( '<div class="yolo_vc_custom_param product_category">' );
            $html[] = '  <input type="hidden" name="' . $settings['param_name'] . '" value="' . $value .
                 '" class="wpb_vc_param_value" />';
            $html[] = '  <select name="' . $settings['param_name'] . '-select"  class="' . $class . '">';
            $html[] = '    <option value="all" ' . ( in_array( 'all', $selected_values ) ? 'selected="true"' : '' ) . '>' .
                 __( 'All', 'yolo-kidzone' ) . '</option>';
            foreach ( $categories as $category ) {
                $html[] = '    <option value="' . $category->term_id . '" ' .
                     ( in_array( $category->term_id, $selected_values ) ? 'selected="true"' : '' ) . '>';   //Product Category
                $html[] = '      ' . $category->name;
                $html[] = '    </option>';
            }
            
            $html[] = '  </select>';
            $html[] = '</div>';
            $html[] = '<script>';
            $html[] = '  jQuery("document").ready( function() {';
            $html[] = '    jQuery( "select[name=\'' . $settings['param_name'] . '-select\']" ).click( function() {';
            $html[] = '      var selected_values = jQuery(this).find("option:selected").map(function(){ return this.value; }).get().join(",");';
            $html[] = '      jQuery( "input[name=\'' . $settings['param_name'] . '\']" ).val( selected_values );';
            $html[] = '    } );';
            $html[] = '  } );';
            $html[] = '</script>';
            
            return implode( "\n", $html );
        }
        vc_add_shortcode_param( 'product_category', 'yolo_vc_custom_param_product_category' );
    

    endif;// Category select field type


    //Product Categories
    if ( ! function_exists( 'yolo_vc_field_type_product_categories' ) ) :

        function yolo_vc_custom_param_product_categories( $settings, $value ) {
            //$dependency = vc_generate_dependencies_attributes( $settings );
            $categories = get_terms( 'product_cat', array( 'orderby' => 'NAME', 'order' => 'ASC' ) );
            $class = 'wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '_field';
            $selected_values = explode( ',', $value );
            $html = array( '<div class="yolo_vc_custom_param product_categories">' );
            $html[] = '  <input type="hidden" name="' . $settings['param_name'] . '" value="' . $value .
                 '" class="wpb_vc_param_value" />';
            $html[] = '  <select name="' . $settings['param_name'] . '-select" multiple="true" class="' . $class . '">';
            $html[] = '    <option value="all" ' . ( in_array( 'all', $selected_values ) ? 'selected="true"' : '' ) . '>' .
                 __( 'All', 'yolo-kidzone' ) . '</option>';
            foreach ( $categories as $category ) {
                $html[] = '    <option value="' . $category->term_id . '" ' .
                     ( in_array( $category->term_id, $selected_values ) ? 'selected="true"' : '' ) . '>';
                $html[] = '      ' . $category->name;
                $html[] = '    </option>';
            }
            
            $html[] = '  </select>';
            $html[] = '</div>';
            $html[] = '<script>';
            $html[] = '  jQuery("document").ready( function() {';
            $html[] = '    jQuery( "select[name=\'' . $settings['param_name'] . '-select\']" ).click( function() {';
            $html[] = '      var selected_values = jQuery(this).find("option:selected").map(function(){ return this.value; }).get().join(",");';
            $html[] = '      jQuery( "input[name=\'' . $settings['param_name'] . '\']" ).val( selected_values );';
            $html[] = '    } );';
            $html[] = '  } );';
            $html[] = '</script>';
            
            return implode( "\n", $html );
        }
        vc_add_shortcode_param( 'product_categories', 'yolo_vc_custom_param_product_categories' );
    

    endif;// Categories select field type

    // Add field type Pricing Plans
    if( !function_exists( 'yolo_vc_field_type_pricing_plans' ) ) {
        function yolo_vc_field_type_pricing_plans( $settings, $value ) {
            //$dependency = vc_generate_dependencies_attributes( $settings );
            $plans = get_terms( 'plan_category', array( 'orderby' => 'NAME', 'order' => 'ASC' ) );
            $class = 'wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '_field';
            $selected_values = explode( ',', $value );

            $html   = array( '<div class="yolo_vc_custom_param pricing_plans">' );
            $html[] = '<input type="hidden" name="' . $settings['param_name'] . '" value="' . $value .
                 '" class="wpb_vc_param_value" />';
            $html[] = '  <select name="' . $settings['param_name'] . '-select" multiple="true" class="' . $class . '">';
            $html[] = '    <option value="all" ' . ( in_array( 'all', $selected_values ) ? 'selected="true"' : '' ) . '>' .
                 __( 'All', 'yolo-kidzone' ) . '</option>';
            foreach ( $plans as $plan ) {
                $html[] = '    <option value="' . $plan->term_id . '" ' .
                     ( in_array( $plan->term_id, $selected_values ) ? 'selected="true"' : '' ) . '>';
                $html[] = '      ' . $plan->name;
                $html[] = '    </option>';
            }

            $html[] = '  </select>';
            $html[] = '</div>';
            $html[] = '<script>';
            $html[] = '  jQuery("document").ready( function() {';
            $html[] = '    jQuery( "select[name=\'' . $settings['param_name'] . '-select\']" ).click( function() {';
            $html[] = '      var selected_values = jQuery(this).find("option:selected").map(function(){ return this.value; }).get().join(",");';
            $html[] = '      jQuery( "input[name=\'' . $settings['param_name'] . '\']" ).val( selected_values );';
            $html[] = '    } );';
            $html[] = '  } );';
            $html[] = '</script>';
            
            return implode( "\n", $html );           
        }

        vc_add_shortcode_param( 'pricing_plans', 'yolo_vc_field_type_pricing_plans' );
    }

    // Add field type Courses ( Yolo Courses )
    if( !function_exists( 'yolo_vc_field_type_courses' ) ) {
        function yolo_vc_field_type_courses( $settings, $value ) {
            //$dependency = vc_generate_dependencies_attributes( $settings );
            $courses = get_terms( 'course_category', array( 'orderby' => 'NAME', 'order' => 'ASC' ) );
            $class = 'wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '_field';
            $selected_values = explode( ',', $value );

            $html   = array( '<div class="yolo_vc_custom_param courses">' );
            $html[] = '<input type="hidden" name="' . $settings['param_name'] . '" value="' . $value .
                 '" class="wpb_vc_param_value" />';
            $html[] = '  <select name="' . $settings['param_name'] . '-select" multiple="true" class="' . $class . '">';
            $html[] = '    <option value="all" ' . ( in_array( 'all', $selected_values ) ? 'selected="true"' : '' ) . '>' .
                 __( 'All', 'yolo-kidzone' ) . '</option>';
            foreach ( $courses as $course ) {
                $html[] = '    <option value="' . $course->term_id . '" ' .
                     ( in_array( $course->term_id, $selected_values ) ? 'selected="true"' : '' ) . '>';
                $html[] = '      ' . $course->name;
                $html[] = '    </option>';
            }

            $html[] = '  </select>';
            $html[] = '</div>';
            $html[] = '<script>';
            $html[] = '  jQuery("document").ready( function() {';
            $html[] = '    jQuery( "select[name=\'' . $settings['param_name'] . '-select\']" ).click( function() {';
            $html[] = '      var selected_values = jQuery(this).find("option:selected").map(function(){ return this.value; }).get().join(",");';
            $html[] = '      jQuery( "input[name=\'' . $settings['param_name'] . '\']" ).val( selected_values );';
            $html[] = '    } );';
            $html[] = '  } );';
            $html[] = '</script>';
            
            return implode( "\n", $html );           
        }

        vc_add_shortcode_param( 'courses', 'yolo_vc_field_type_courses' );
    }

    // Add field type Teachers ( Yolo Teachers )
    if( !function_exists( 'yolo_vc_field_type_teachers' ) ) {
        function yolo_vc_field_type_teachers( $settings, $value ) {
            //$dependency = vc_generate_dependencies_attributes( $settings );
            $teachers = get_terms( 'teacher_category', array( 'orderby' => 'NAME', 'order' => 'ASC' ) );
            $class = 'wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '_field';
            $selected_values = explode( ',', $value );

            $html   = array( '<div class="yolo_vc_custom_param teachers">' );
            $html[] = '<input type="hidden" name="' . $settings['param_name'] . '" value="' . $value .
                 '" class="wpb_vc_param_value" />';
            $html[] = '  <select name="' . $settings['param_name'] . '-select" multiple="true" class="' . $class . '">';
            $html[] = '    <option value="all" ' . ( in_array( 'all', $selected_values ) ? 'selected="true"' : '' ) . '>' .
                 __( 'All', 'yolo-kidzone' ) . '</option>';
            foreach ( $teachers as $teacher ) {
                $html[] = '    <option value="' . $teacher->term_id . '" ' .
                     ( in_array( $teacher->term_id, $selected_values ) ? 'selected="true"' : '' ) . '>';
                $html[] = '      ' . $teacher->name;
                $html[] = '    </option>';
            }

            $html[] = '  </select>';
            $html[] = '</div>';
            $html[] = '<script>';
            $html[] = '  jQuery("document").ready( function() {';
            $html[] = '    jQuery( "select[name=\'' . $settings['param_name'] . '-select\']" ).click( function() {';
            $html[] = '      var selected_values = jQuery(this).find("option:selected").map(function(){ return this.value; }).get().join(",");';
            $html[] = '      jQuery( "input[name=\'' . $settings['param_name'] . '\']" ).val( selected_values );';
            $html[] = '    } );';
            $html[] = '  } );';
            $html[] = '</script>';
            
            return implode( "\n", $html );           
        }

        vc_add_shortcode_param( 'teachers', 'yolo_vc_field_type_teachers' );
    }

    // Add field type Events ( Yolo Events )
    if( !function_exists( 'yolo_vc_field_type_events' ) ) {
        function yolo_vc_field_type_events( $settings, $value ) {
            //$dependency = vc_generate_dependencies_attributes( $settings );
            $events = get_posts (array (
                    'post_type' => 'event',
                    'orderby' => 'title',
                    'order' => 'ASC',
                    'numberposts'   => '-1'
                ));

            $class = 'wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '_field';
            $selected_values = explode( ',', $value );

            $html   = array( '<div class="yolo_vc_custom_param events">' );
            $html[] = '<input type="hidden" name="' . $settings['param_name'] . '" value="' . $value .
                 '" class="wpb_vc_param_value" />';
            $html[] = '  <select name="' . $settings['param_name'] . '-select" multiple="true" class="' . $class . '">';
            $html[] = '    <option value="all" ' . ( in_array( 'all', $selected_values ) ? 'selected="true"' : '' ) . '>' .
                 __( 'All', 'yolo-kidzone' ) . '</option>';
            foreach ( $events as $event ) {
                $html[] = '    <option value="' . $event->ID . '" ' .
                     ( in_array( $event->ID, $selected_values ) ? 'selected="true"' : '' ) . '>';
                $html[] = '      ' . $event->post_title;
                $html[] = '    </option>';
            }

            $html[] = '  </select>';
            $html[] = '</div>';
            $html[] = '<script>';
            $html[] = '  jQuery("document").ready( function() {';
            $html[] = '    jQuery( "select[name=\'' . $settings['param_name'] . '-select\']" ).click( function() {';
            $html[] = '      var selected_values = jQuery(this).find("option:selected").map(function(){ return this.value; }).get().join(",");';
            $html[] = '      jQuery( "input[name=\'' . $settings['param_name'] . '\']" ).val( selected_values );';
            $html[] = '    } );';
            $html[] = '  } );';
            $html[] = '</script>';
            
            return implode( "\n", $html );           
        }

        vc_add_shortcode_param( 'events', 'yolo_vc_field_type_events' );
    }


    // Add field type Portfolio ( Yolo portfolio )
    if( !function_exists( 'yolo_vc_field_type_portfolio' ) ) {
        function yolo_vc_field_type_portfolio( $settings, $value ) {
            //$dependency = vc_generate_dependencies_attributes( $settings );
            $portfolio = get_terms( 'portfolio_category', array( 'orderby' => 'NAME', 'order' => 'ASC' ) );
            $class = 'wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '_field';
            $selected_values = explode( ',', $value );

            $html   = array( '<div class="yolo_vc_custom_param portfolio">' );
            $html[] = '<input type="hidden" name="' . $settings['param_name'] . '" value="' . $value .
                 '" class="wpb_vc_param_value" />';
            $html[] = '  <select name="' . $settings['param_name'] . '-select" multiple="true" class="' . $class . '">';
            $html[] = '    <option value="all" ' . ( in_array( 'all', $selected_values ) ? 'selected="true"' : '' ) . '>' .
                  __( 'All', 'yolo-kidzone' ) . '</option>';
            foreach ( $portfolio as $project ) {
                $html[] = '    <option value="' . $project->term_id . '" ' .
                     ( in_array( $project->term_id, $selected_values ) ? 'selected="true"' : '' ) . '>';
                $html[] = '      ' . $project->name;
                $html[] = '    </option>';
            }

            $html[] = '  </select>';
            $html[] = '</div>';
            $html[] = '<script>';
            $html[] = '  jQuery("document").ready( function() {';
            $html[] = '    jQuery( "select[name=\'' . $settings['param_name'] . '-select\']" ).click( function() {';
            $html[] = '      var selected_values = jQuery(this).find("option:selected").map(function(){ return this.value; }).get().join(",");';
            $html[] = '      jQuery( "input[name=\'' . $settings['param_name'] . '\']" ).val( selected_values );';
            $html[] = '    } );';
            $html[] = '  } );';
            $html[] = '</script>';
            
            return implode( "\n", $html );           
        }

        vc_add_shortcode_param( 'portfolio', 'yolo_vc_field_type_portfolio' );
    }

endif;

if ( defined( 'WPB_VC_VERSION' ) ) :
    if ( ! function_exists( 'yolo_vc_admin_enqueue_assets' ) ) :

        function yolo_vc_admin_enqueue_assets( $hook ) {
            if ( $hook != 'edit.php' && $hook != 'post.php' && $hook != 'post-new.php' ) {
                return;
            }
            // Enqueue script for VC admin
            wp_register_script(
                'yolo-vc-admin-js',
                YOLO_ADMIN_ASSETS_URI . '/js/yolo-vc-admin.js',
                null,
                null,
                false );
            wp_enqueue_script( 'yolo-vc-admin-js' );
        }

    endif;
    add_action( 'admin_enqueue_scripts', 'yolo_vc_admin_enqueue_assets' );

endif;


    /* Add type lookbook*/
    if (!function_exists('yolo_vc_field_type_statistical')) :

        function yolo_vc_field_type_statistical($settings, $value)
        {
            //$dependency = vc_generate_dependencies_attributes($settings);

            $categories = get_terms('product_lookbook');
            $class = 'wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '_field';
            $selected_values = explode(',', $value);
            $html = array('<div class="yolo_vc_custom_param post_categories">');
            $html[] = '  <input type="hidden" name="' . $settings['param_name'] . '" value="' . $value .
                '" class="wpb_vc_param_value" />';
            $html[] = '  <select name="' . $settings['param_name'] . '-select" multiple="true" class="' . $class . '">';
            $html[] = '    <option value="all" ' . (in_array('all', $selected_values) ? 'selected="true"' : '') . '>' .
                __('All', 'yolo-kidzone') . '</option>';
            foreach ($categories as $category) {
                $html[] = '    <option value="' . $category->term_id . '" ' .
                    (in_array($category->term_id, $selected_values) ? 'selected="true"' : '') . '>';
                $html[] = '      ' . $category->name;
                $html[] = '    </option>';
            }

            $html[] = '  </select>';
            $html[] = '</div>';
            $html[] = '<script>';
            $html[] = '  jQuery("document").ready( function() {';
            $html[] = '    jQuery( "select[name=\'' . $settings['param_name'] . '-select\']" ).click( function() {';
            $html[] = '      var selected_values = jQuery(this).find("option:selected").map(function(){ return this.value; }).get().join(",");';
            $html[] = '      jQuery( "input[name=\'' . $settings['param_name'] . '\']" ).val( selected_values );';
            $html[] = '    } );';
            $html[] = '  } );';
            $html[] = '</script>';

            return implode("\n", $html);
        }

        vc_add_shortcode_param('statistical', 'yolo_vc_field_type_statistical');
    endif;

?>