<?php

/*
 * Shortcode attubutes
 *
 * */

if (!function_exists('yolo_shortcode_clients')) {

    function yolo_shortcode_clients($atts)
    {
        extract(shortcode_atts(array(
            'style' => 'slider',
            'control' => 'show',
            'values' => '',
            'target' => 'same'
        ), $atts));
        ob_start();
        wp_enqueue_style('owl-carousel');
        wp_enqueue_script('owl-carousel');
        $values = (array) vc_param_group_parse_atts( $values);
        $class_style = '';
        if( $style != 'slider' ):
            $class_style = 'yolo-clients-default';
        endif;
            ?>
            <div class="clients <?php echo esc_attr($class_style); ?>">
                <div class="yolo-row">
                    <?php if( $values ) : ?>
                    <ul class="yolo_clients owl-carousel">
                        <?php foreach ($values as $value) : ?>
                            <li >
                                <a <?php if ($target == 'new') { ?> target="_blank" <?php } ?>
                                href="<?php echo $value['label']; ?>">
                                 <?php echo wp_get_attachment_image(esc_attr($value['value']),$size='full'); ?>                            
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
                </div>
            </div>
            <?php if ($style == 'slider'): ?>
                <script>
                jQuery(document).ready(function ($) {

                    $('.yolo_clients').owlCarousel({

                            loop:true,
                            margin: 10,
                            nav: <?php echo ($control == 'show') ? true: false; ?>,
                            navText: ["<i class='fa fa-chevron-left'></i>","<i class='fa fa-chevron-right'></i>"],
                            dots: false,

                            items : 6,
                            // Responsive 
                            responsive:{
                            0:{
                                items:2
                            },
                            600:{
                                items:3
                            },
                            1000:{
                                items : 6,
                            }
                        }
                        });

                });
            </script>
            <?php
        endif;

        $clients = ob_get_contents();
        ob_end_clean();
        return $clients;
    }
    add_shortcode('yolo_clients', 'yolo_shortcode_clients');
}
?>