<?php

/**
 * Shortcode attributes
 * @var $courses
 * @var $style
 * @var $columns
 * @var $post_per_page
 * @var $pagination
 * @var $text
 * @var $sub_text
 * @var $class
 */


if(!function_exists('yolo_courses_shortcode')) {
	function yolo_courses_shortcode($atts){
		extract( shortcode_atts( array(
			'courses' 		=> 'all',
			'style' 		=> 'grid',
			'columns' 		=> 3,
			'posts_per_page' => 3,
			'excerpt_length'=> '55',
			'pagination' 	=> 'show',
			'class' 		=> '',

		), $atts ) );
		
		ob_start();

		// Use this for pagination
		if( is_front_page() || is_home()) {
			$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : ( ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1 );
		} else {
			$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
		}

		$args = array(
			'paged'				=> $paged,
			'post_type' 		=> 'course',
			'post_status'		=> 'publish',
			'posts_per_page'	=> $posts_per_page,
			'orderby'			=> 'modified',
			'order'				=> 'DESC'
		);

		if( $courses != 'all' ) {
			$args['tax_query'] = array(
				'relation' => 'AND',
				array(
					'taxonomy' 		=> 'course_category',
					'field'    		=> 'term_id',
					'terms'    		=>  explode( ',', $courses),
					'operator' 		=> 'IN',
				),
			);
		}

		$r = new WP_Query( $args );
		$grid_column = '';
		$grid_column .= (($style === 'grid') ? ' columns-'.$columns : '');
?>
		<div class="yolo-courses <?php if($style != '') echo esc_attr($style);?> clearfix">
			<ul class="courses-info clearfix">
				<?php if( $r->have_posts() ) : ?>
					<?php while( $r->have_posts() ) : $r->the_post();
					global $post;
						$course_teacher 		= get_post_meta( get_the_ID(), '_course_teacher', true );
						$teacher_permanlink 	= get_post_permalink( $course_teacher );
						$teacher_name 			= get_the_title( $course_teacher );
			            
					?>
					<li class="course-item <?php if($style == 'grid' && $grid_column != '') echo esc_attr($grid_column);?> clearfix">
						<div class="yolo-course clearfix">
							<div class="course-image">
								<?php the_post_thumbnail(); ?>
								<div class="mask">
									<a href="<?php echo get_post_permalink(); ?>">
										<i class="fa fa-mail-forward"></i>
									</a>
								</div>
							</div>
							<div class="course-information">
								<div class="course-title">
									<h3><a href="<?php echo get_post_permalink(); ?>"><?php the_title(); ?></a></h3>
									<?php if(!empty($course_teacher)):?>
										<h4><i class="fa fa-briefcase"></i> <a href="<?php echo $teacher_permanlink; ?>"><?php echo esc_html($teacher_name); ?></a></h4>
									<?php endif;?>
								</div>
								<div class="course-content">
									<div class="course-excerpt">
										<?php
										   $excerpt = $post->post_excerpt;
											if(empty($excerpt))
												$excerpt = $post->post_content;
												$excerpt = strip_shortcodes($excerpt);
												$excerpt = wp_trim_words($excerpt,$excerpt_length,'...');
										?>
										<p><?php echo esc_html($excerpt);?></p>
									</div>
									<div class="course-readmore">
										<a class = "read-more" href="<?php echo get_post_permalink(); ?>"><?php _e( 'Read more', 'yolo-kidzone' ); ?></a>
									</div>
								</div>
							</div>
						</div>
					</li>
					<?php endwhile; ?>
				<?php endif; ?>
			</ul>
			<?php 
			if($pagination == 'show') {
				echo yolo_pagination_normal( $args, $r );
			}
			?>
		</div>
	<?php
	wp_reset_query();
	return ob_get_clean();
	}
	add_shortcode('yolo_courses', 'yolo_courses_shortcode');
}

?>