<?php

/**
 * Shortcode attributes
 * @var $events
 * @var $style
 * @var $columns
 * @var $post_per_page
 * @var $pagination
 * @var $text
 * @var $sub_text
 * @var $class
 */


if(!function_exists('yolo_events_shortcode')) {
	function yolo_events_shortcode($atts){
		extract( shortcode_atts( array(
			'title' 		=> '',
			'sub_title' 	=> '',
			'data_source'   => '',
			'category' 		=> '',
			'event_ids'     => '',
			'style' 		=> 'grid',
			'columns' 		=> 3,
			'posts_per_page' => 3,
			'pagination' 	=> 'hide',
			'excerpt_length'=> 20,
			'class' 		=> '',

		), $atts ) );
		
		ob_start();

		// Use this for pagination
		if( is_front_page() || is_home()) {
			$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : ( ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1 );
		} else {
			$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
		}
		$args = array(
			'paged'				=> $paged,
			'post_type' 		=> 'event',
			'post_status'		=> 'publish',
			'posts_per_page'	=> $posts_per_page,
			'orderby'			=> 'post_date',
			'order'				=> 'DESC'
		);

		if( !empty($category) && $category != 'all') {
			$args['tax_query'] = array( 
				'relation' => 'AND',
				array(
					'taxonomy' 		=> 'event_category',
					'field'    		=> 'id',
					'terms'    		=>  array_map('sanitize_title', explode(',', $category)),
					'operator' 		=> 'IN',
				),
			);
		}

		// If data_source = event_list_id
		if( !empty($event_ids) && $event_ids != 'all') {
            $args = array(
            	'paged'				=> $paged,
                'post_type' 		=> 'event',
				'post_status'		=> 'publish',
				'posts_per_page'	=> $posts_per_page,
				'orderby'			=> 'post_date',
				'order'				=> 'DESC',
                'post__in'       	=> explode( ',' , $event_ids ),
            );
	    }

		ob_start();

		$r = new WP_Query( $args );
		$grid_column = '';
		$grid_column .= (($style === 'grid') ? ' columns-'.$columns : '');
?>
		<div class="yolo-events <?php if($style != '') echo esc_attr($style);?> clearfix">
			<ul class="events-info">
				<?php if( $r->have_posts() ) : ?>
					<?php while( $r->have_posts() ) : $r->the_post();
					global $post;
						$start_time 	= yolo_get_post_meta( get_the_ID(), '_yolo_wp_post_start_time', true );
						$end_time 		= yolo_get_post_meta( get_the_ID(), '_yolo_wp_post_end_time', true );
						$address 		= yolo_get_post_meta( get_the_ID(), '_yolo_wp_post_address', true );
						$date_format = get_option('date_format');
						//$date_format = $date_format . ' ' . get_option('time_format');
						$start_time = date_i18n( $date_format, $start_time );
						$end_time = date_i18n( $date_format, $end_time );
						$compare_start = substr($start_time,0,12);
						$compare_end = substr($end_time,0,12);
						$a = strcmp($compare_start,$compare_end);
					?>
					<li class="event-item <?php if($style == 'grid' && $grid_column != '') echo esc_attr($grid_column); echo esc_attr($class); ?> clearfix">
						<div class="yolo-event clearfix">
							<div class="event-image">
								<?php the_post_thumbnail(); ?>
								<div class="mask">
									<a href="<?php echo get_post_permalink(); ?>">
										<i class="fa fa-mail-forward"></i>
									</a>
								</div>
							</div>
							<div class="event-information">
								<div class="event-title">
									<h3><a href="<?php echo get_post_permalink(); ?>"><?php the_title(); ?></a></h3>
									<?php if( $category_list = get_the_term_list( get_the_ID(), 'event_category', '', ', ' ) ) : ?>
									<h4>
										<i class="fa fa-bookmark"></i>
										<?php echo $category_list; ?>
									</h4>
									<?php endif; ?>
									<?php if ($start_time != '' && $date_format !=''):?>
										<?php if($a != 0):?>
											<div class="event-time">
												<span class="event-start">
												<i class="fa fa-calendar"></i><?php echo $start_time; ?>
												</span> -- 
												<span class="event-end">
												<?php echo $end_time; ?>
												</span>
											</div>
										<?php else:?>
											<div class="event-time">
												<span class="event-start">
												<i class="fa fa-calendar"></i><?php echo $start_time; ?>
												</span>
											</div>
										<?php endif;?>

									<?php endif;?>
									<?php if(!empty($address)):?>
									<div class="event-address">
										<i class="fa fa-map-marker"></i><?php echo esc_html($address); ?>
									</div>
									<?php endif;?>
								</div>
								<div class="event-content">
									<div class="event-excerpt">
										<?php //the_excerpt();
										$excerpt = $post->post_excerpt;
											if(empty($excerpt))
												$excerpt = $post->post_content;
											
											$excerpt = strip_shortcodes($excerpt);
											$excerpt = wp_trim_words($excerpt,$excerpt_length,'...');
										?>
										<p><?php echo esc_html($excerpt);?></p>
									</div>
									<div class="event-readmore">
										<a class = "read-more" href="<?php echo get_post_permalink(); ?>"><?php esc_html_e( 'Read more', 'yolo-kidzone' ); ?></a>
									</div>
									
								</div>
							</div>
						</div>
					</li>
					<?php endwhile; ?>
				<?php endif; ?>
			</ul>
			<div class ="clearfix"></div>
			<?php 
			if($pagination == 'show') {
				echo yolo_pagination_normal( array(), $r );
			}
			?>
		</div>
	<?php
	wp_reset_query();
	return ob_get_clean();
	}

	add_shortcode('yolo_events', 'yolo_events_shortcode');

}

?>