<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $number
 * @var $text
 */

if( !function_exists('yolo_shortcode_highlight') ){
    function yolo_shortcode_highlight($atts){
        extract(shortcode_atts(array(
            'title'      =>  '',
            'sub_text' => '',
            'font_icon' => '',
            'color' => '',
            'highlight_image' => '',
            'image_link' => '',
            ),$atts));
        ob_start();
         $img = '';
        if( isset( $highlight_image ) && !empty( $highlight_image ) ){
            $bk_array = wp_get_attachment_image_src( $highlight_image,'full' );
            $image = $bk_array[0];
        }
        ?>
        <div class="yolo-highlight">
            <div class="yolo-highlight-outer" style="border-color:<?php echo $color ?>;">
                <div class="yolo_highlight-box" style="background-color:<?php echo $color ?>;
                border-color:<?php echo $color ?>;">
                    <?php if( isset($font_icon) && $font_icon != '' ): ?><i class="<?php echo esc_attr($font_icon); ?>"></i><?php endif; ?>
                </div>
            </div>
            <div class="highlight-text" >
             <h2 class="title"><strong><?php echo esc_html($title); ?></strong></h2>
             <p class="sub_text"><?php echo esc_html($sub_text); ?></p>
             <img src="<?php echo esc_url($image);?>" alt = "<?php echo esc_html($sub_text); ?>"/>
            </div>       
        </div>      

        <?php
        $yolo_highlight = ob_get_contents();
        ob_end_clean();
        return $yolo_highlight;
    }
    add_shortcode('yolo_highlight','yolo_shortcode_highlight');
}
?>