<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $number
 * @var $text
 */
if( !function_exists('yolo_shortcode_newsletter') ){
    function yolo_shortcode_newsletter($atts){
        extract(shortcode_atts(array(
            'title'    =>  '',
            'subscribe_text'    =>  '',
            'mail_list'         =>  '',
            'phone_number'      => '',
            'bg_image'          => '',
            ),$atts));
        ob_start();
        $image = '';
        if( isset( $bg_image )){
          $bk_array = wp_get_attachment_image_src( $bg_image,'full' );
          if (isset($bk_array[0]))
            $image = $bk_array[0];
        }

        ?>
        <div class="yolo-newsletter">
            <div class="title-newsletter yolo-lg-2 yolo-md-3">
                <h2 class="" style="background-image:url('<?php echo esc_attr($image) ?>');"><?php echo esc_html($title); ?></h2> 
            </div> 
            <div class="form-newsletter yolo-lg-6 yolo-md-5">
                <form class="yolo-newsltter-form mc-subscribe-form<?php echo (isset($_COOKIE['yolo_subscribed']) ? ' submited':'')?>">
                    <?php if( isset($_COOKIE['yolo_subscribed']) ) : ?>
                        <label class="yolo-message alert"><?php _e( 'You\'ve already subscribed.', 'yolo-kidzone' ); ?></label>
                    <?php else: ?>
                        <input type="email" id="email" name="mc_email" class="mc-email" value="" placeholder="<?php _e( 'Enter your email here', 'yolo-kidzone' ); ?>" />
                        <button><?php echo __('subscribe', 'yolo-kidzone'); ?></button>
                        <input type="hidden" name="mc_list_id" value="<?php echo esc_attr( $mail_list ); ?>" />
                        <input type="hidden" name="action" value="yolo_mc_subscribe" />
                        <?php wp_nonce_field('yolo-subscribe','nonce'); ?>
                    <?php endif; ?>
                </form>
                <p class="subscribe-text"><?php echo esc_html($subscribe_text); ?></p>
            </div>
            <div class="yolo-lg-4 yolo-md-4">
                <div class="phone-newsletter ">
                    <i class="fa fa-mobile-phone"></i>
                    <h3><?php echo esc_html($phone_number); ?></h3> 
                </div>
            </div>
            
        </div>
        <?php
        $newsletter = ob_get_contents();
        ob_end_clean();
        return $newsletter;
    }
    add_shortcode('yolo_newsletter','yolo_shortcode_newsletter');
}
?>