<?php

/**
 * Shortcode attributes
 * @var $portfolio
 * @var $style
 * @var $columns
 * @var $post_per_page
 * @var $pagination
 * @var $text
 * @var $sub_text
 * @var $class
 */


if(!function_exists('yolo_portfolio_shortcode')) {
	function yolo_portfolio_shortcode($atts) {
		extract( shortcode_atts( array(
			'title'              => '',
			'sub_title'          => '',
			'portfolio'          => 'all',
			'style'              => 'grid',
			'hover_effect'       => 'effect1',
			'columns'            => 3,
			'posts_per_page'     => 3,
			'portfolio_filter'   => '',
			'show_all_tab'		 => '',
			'filterbar_position' => 'left',
			'pagination'         => 'show',
			'class'              => '',

		), $atts ) );
		
		

		// Use this for pagination
		if( is_front_page() || is_home()) {
			$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : ( ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1 );
		} else {
			$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
		}

		if( !empty($portfolio) && $portfolio != 'all' ) {
			$category_arr = explode(',', $portfolio);
			foreach($category_arr as $key => $value){
				$args = array(
                        'post_type'      => 'portfolio',
                        'post_status'    => 'publish',
                        'orderby'        => 'NAME',
                        'order'          => 'DESC',
                        'posts_per_page' => $posts_per_page,
                        'tax_query'      => array(
                            array(
                                'taxonomy' => 'portfolio_category',
                                'terms'    =>  $value,
                                'field'    => 'term_id',
                                'operator' => 'IN'
                            )
                        )
                    );
				$tmp_portfolio[$key] = new WP_Query($args);
			}
			 $ids_portfolio = array();
                foreach ($tmp_portfolio as $key => $val) {
                    foreach ($val->posts as $k => $v) {
                        $ids_portfolio[] = $v->ID;
                    }
                }

            $args = array(
                'post_type'      => 'portfolio',
                'post_status'    => 'publish',
                'orderby'        => 'NAME',
                'order'          => 'DESC',
                'posts_per_page' => $posts_per_page*count($category_arr),
                'post__in'       => $ids_portfolio
            );
		} else {
			$args = array(
				'paged'				=> $paged,
				'post_type' 		=> 'portfolio',
				'post_status'		=> 'publish',
				'posts_per_page'	=> $posts_per_page,
				'orderby'			=> 'NAME',
				'order'				=> 'DESC',
			);
			$portfolio_taxonomy = get_terms( 'portfolio_category', array( 'orderby' => 'NAME', 'order' => 'ASC' ) );
			foreach( $portfolio_taxonomy as $category ) :
				$category_arr[] = $category->term_id;
			endforeach;
			
		}
		$r = new WP_Query( $args );
		ob_start();
		wp_enqueue_script('yolo-portfolio');
		
		wp_enqueue_style('owl-carousel');
        wp_enqueue_script('owl-carousel');
		
		$light_box_class = '';
		$light_box_class .=' noo-lightbox-wrapper';
		$lightbox = true;
		wp_enqueue_script( 'yolo-vendor-nivo-lightbox-js' );

    	$data_section_id = uniqid();


?>		
		<!-- Portfolio -->
		<div class="yolo-portfolio<?php echo $data_section_id; ?> yolo-portfolio masonry <?php if( $hover_effect != 'effect1' ) { echo 'vc_row'; } ?> clearfix <?php echo esc_attr($hover_effect); ?>" id="yolo-portfolio-<?php echo esc_attr($data_section_id) ?>" data-paginate="loadmore">
			<!-- Section Name -->
			<div class="section-name index-1">
				<!-- <h1><?php esc_html__( 'Our Gallery', 'yolo-kidzone' ); ?></h1> -->
				<div class="sep"></div>
			</div>

			<!-- Item Filter -->
			<?php if($portfolio_filter == true) : ?>
				<?php if($filterbar_position != '') : ?>
					<ul class="category-filter masonry-filters clearfix <?php echo esc_attr($filterbar_position);?>" data-option-key="filter">
						<?php if($show_all_tab == true):?>
							<li>
								<a href="#" data-option-value= "*"><i class="fa fa-circle"></i><?php echo esc_html_e( 'All', 'yolo-kidzone' ) ?></a>
							</li>
						<?php endif;?>
						<?php
						if(!empty($category_arr)) :
							foreach ($category_arr as $cat) :
								$category = get_term($cat, 'portfolio_category');
							?>
							<li>
								<a href="#" data-option-value= ".<?php echo $category->slug;?>"><i class="fa fa-circle"></i><?php echo esc_html($category->name); ?></a>
							</li>
							<?php endforeach; ?>
						<?php endif;?>
					</ul>
				<?php endif; ?>
			<?php endif; ?>

			<ul class="portfolio-wrap masonry-container">
				<?php if( $r->have_posts() ) : ?>
					<?php while( $r->have_posts() ) : $r->the_post();
						$post_categories = get_the_terms( get_the_ID(), 'portfolio_category');
						$cat_class = '';
						if(!empty($post_categories)):
							foreach ( $post_categories as $cat ) {
								if ( !empty($cat->slug ) )
									$cat_class .= " ".sanitize_html_class($cat->slug, $cat->term_id);
							}
						endif;
							$item_class = 'portfolio-item columns-'.$columns.' masonry-item '.$cat_class;
					?>
					<li class = "<?php echo esc_html($item_class);?> yolo-lightbox-wrapper loadmore-item">
						<div class="yolo-portfolio">
							<div class="portfolio-image">
								<?php yolo_html_portfolio( null, '', $lightbox, true ); ?>
								<div class="overlay">
									<div class="details">
										<?php if( $category_list = get_the_term_list( get_the_ID(), 'portfolio_category', '', ', ' ) ) : ?>
										<h5><?php echo strip_tags($category_list); ?></h5>
										<?php endif; ?>
										<h6><?php the_title(); ?></h6>
									</div>
									<?php yolo_portfolio_action( null, '', $lightbox, true ); ?>
								</div>
							</div>
							<div class="info-block">
								<h5><?php the_title(); ?></h5>
								<?php if( $category_list = get_the_term_list( get_the_ID(), 'portfolio_category', '', ', ' ) ) : ?>
								<h6><?php echo strip_tags($category_list); ?></h6>
								<?php endif; ?>
								<?php yolo_portfolio_action( null, '', $lightbox, true ); ?>
							</div>
						</div>
					</li>
					<?php endwhile; ?>
				<?php endif; ?>
			</ul>
			<?php if (1 < $r->max_num_pages): ?>
				<div class="yolo-loadmore-action">
					<div class="loadmore-loading" style="display: block;">
						<div class="fade-loading"><i class="fa fa-refresh fa-spin"></i></div>
					</div>
				</div>
				<div class="<?php echo 'yolo_' . esc_attr($pagination); ?>"
					 style="<?php if ($pagination == 'show') {
						 echo 'display: block;';
					 } else {
						 echo 'display:none;';
					 } ?>">
					<?php yolo_pagination( array( 'is_front_page' => is_front_page() ), $r) ?>
				</div>
			<?php endif; ?>
		</div>
			
		<?php
			wp_reset_query();
			return ob_get_clean();
	}

	add_shortcode('yolo_portfolio', 'yolo_portfolio_shortcode');
}

?>