<?php

/**
 * Shortcode attributes
 * @var $plans
 * @var $columns
 * @var $text
 * @var $sub_text
 * @var $class
 */


if(!function_exists('yolo_pricing_plans_shortcode')) {
	function yolo_pricing_plans_shortcode($atts) {
		extract( shortcode_atts( array(
			'title'    => '',
			'price'     => '',
			'link'     => '',
			'values'   => '',
			'height'   => '',
			'el_class' => ''
		), $atts ) );
		ob_start();
	$values = (array) vc_param_group_parse_atts( $values );
?>
		<div class="yolo-pricing-plans">
			<ul class="pricing-plans-info">
				<li class = "plans-item">
					<div class="yolo-pricing-plan <?php echo esc_html__($el_class); ?>" style="<?php if( $height !='' ) { echo 'height:'.$height.'px'; } ?>">
						<div class="plan-title">
							<h2><?php echo esc_html($title); ?></h2>
							<p><?php echo esc_html($price); ?></p>
						</div>
						<div class="plan-additional clearfix">
							<?php if( $values ) : ?>
								<ul class=" plan-detail clearfix">
								<?php foreach ($values as $value) : ?>
									<li class="additional">
										<?php echo $value['label']; ?>
									</li>
								<?php endforeach; ?>
								</ul>
							<?php endif; ?>
						</div>
						<div class="plan-bottom">
							<a href="<?php echo esc_url($link); ?>"><?php _e( 'Details', 'yolo-kidzone' ); ?></a>
						</div>
					</div>
				</li>
			</ul>
		</div>
	<?php
	wp_reset_query();
	return ob_get_clean();
	}
	add_shortcode('yolo_pricing_plans', 'yolo_pricing_plans_shortcode');
}

?>