<?php

/**
 * Shortcode attributes
 * @var $style
 * @var $list_active
 * @var $description
 */
if( !function_exists('yolo_shortcode_recent_news') ){
	function yolo_shortcode_recent_news($atts){
		extract( shortcode_atts( array(
			'style'				=> 'index-1',
			'posts_per_page'	=> '',
			'excerpt_length'	=> '20',
			'class'             => '',
			'categories'          => 'all',
			), $atts ) );

		$class = ( $class != '' ) ? 'yolo-recent-news posts-loop grid ' . esc_attr( $class ) : 'yolo-recent-news posts-loop grid';
		$html = '';		
		$args = array(
			'posts_per_page'      => $posts_per_page,
			'no_found_rows'       => true,
			'post_status'         => 'publish',
			'ignore_sticky_posts' => true,
			);
		if(!empty($categories) && $categories != 'all'){
			$args['cat'] = $categories;
		}
		$r = new WP_Query($args);
		ob_start();
		if($r->have_posts()):
			?>
		<div class="<?php echo (' ' . $class ); ?> <?php echo $style; ?>">
			<?php 
			$i = 0;
			?>
			<?php if ($style=='index-1')
				$columns='2';
			else
				$columns='1';
			?>
			<?php while ($r->have_posts()): $r->the_post();?>
				<?php global $post;?>

					<div class="yolo-recent-item loop-item yolo-md-<?php echo absint((12 / $columns)) ?> yolo-sm-6 yolo-xs-12 <?php echo ($i%2)?'odd': 'even'; ?>">
						<div class="loop-item-wrap">
							<?php //if(has_post_thumbnail()):?>
								<div class="loop-item-featured" >
								<div class="news-image <?php if( $i%2 == 0 ) { echo "image-align-left"; } else { echo "image-align-right"; } ?>">
									<a href="<?php echo get_permalink();?>">
										<?php the_post_thumbnail('yolo-thumbnail-square')?>
									</a>
									<div class="mask">
									<a href="<?php echo get_permalink();?>">
										<i class="fa fa-mail-forward"></i>
									</a>
								</div>
								</div>
									<div class="loop-item-content">
								<h4 class="loop-item-title">
									<a href="<?php echo get_permalink(); ?>" title="<?php echo esc_attr( sprintf( __( 'Permanent link to: "%s"', 'yolo-kidzone' ), the_title_attribute( 'echo=0' ) ) ); ?>"><?php the_title(); ?></a>
								</h4>
								<div class="yolo-rn-date">
									<i class="fa fa-calendar"></i>
									<?php echo get_the_date('d')?>
									<span><?php echo get_the_date('M')?></span>,
									<span><?php echo get_the_date('Y')?></span>
								</div>
								<div class="yolo-rn-author">
									<i class="fa fa-pencil"></i>
									<span><?php echo get_the_author(); ?></span>
								</div>
								<div class="loop-item-excerpt">
									<?php
									$excerpt = $post->post_excerpt;
									if(empty($excerpt))
										$excerpt = $post->post_content;

									$excerpt = strip_shortcodes($excerpt);
									echo '<p>' . wp_trim_words($excerpt,$excerpt_length,'...') . '</p>';
									?>
								</div>
								<a href="<?php echo get_permalink();?>" class="read-more">
									<?php echo __('Read more', 'yolo-kidzone' ) ?>
								</a>
							</div>
								</div>
							<?php //endif;?>
							
						</div>
					</div>
					<?php $i++ ?>
			<?php endwhile;?>
		</div>
		<?php
		endif;
		$html .= ob_get_clean();
		wp_reset_query();
		return $html;

	}
	add_shortcode('yolo_recent_news','yolo_shortcode_recent_news');

}
?>