<?php
/**
 * Shortcode attributes
 * @var $post_type
**/
//generate taxonomy terms
function listTax($tax){ 
  $terms = get_terms($tax);
  $the_tax = get_taxonomy($tax);
  $tax_name = $the_tax->labels->name;
  $x = '<select name="category">';
  $x .= '<option value="">'.esc_html__('ALL','yolo-kidzone').' '. $tax_name .'</option>';
  foreach ($terms as $term) {
     $x .= '<option value="' . $term->slug . '">' . $term->name . '</option>';  
  }
  $x .= '</select>';
  return $x;
}
if( !function_exists('yolo_search_post_type')){
  function yolo_search_post_type($atts, $content){
  	extract( shortcode_atts( array(
			'post_type'            => 'product',
			), $atts ) );
  	ob_start();
  	$tax = '';
  	if($post_type == 'product'){
  		$tax = 'product_cat';
  	}else{
  		$tax = $post_type.'_category';
  	}
?>
<div class="search-post-type yolo-container">
	<form class="search-post" action="<?php echo home_url('/')?>" method="GET">
		<input type="hidden" value="<?php echo esc_attr($post_type);?>" name="posttype">
		<input type="hidden" value="<?php echo esc_attr($tax);?>" name="taxonomy">
	    <div>
	      <input class="" type="search" placeholder="<?php echo esc_html_e('KEYWORD', 'yolo-kidzone')?>" name="s" value="<?php echo get_search_query(); ?>">
	    </div>
	    <div>
	    <?php echo listTax($tax);?>
	    </div>
	    <div>
	      <input type="submit" value="<?php echo esc_html_e('SEARCH', 'yolo-kidzone')?>">
	    </div>
	    
   </form>
</div>
<?php 
	return ob_get_clean();
	}
add_shortcode('yolo_search_post','yolo_search_post_type');
}
?>