<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $number
 * @var $text
 */

if( !function_exists('yolo_shortcode_statistical') ){
    function yolo_shortcode_statistical($atts){
        extract(shortcode_atts(array(
            'title'      =>  '',
            'number' => '',
            'font_icon' => '',
            'color' => '',
            'style' =>'index-1',
            ),$atts));
        ob_start();
        wp_enqueue_script('yolo-count');
        wp_enqueue_script('yolo-waypoint');
        $control_class = 'counting'.uniqid();
        ?>
        <div class="yolo-statistical-box <?php echo esc_attr($style); ?>" style="color:<?php echo esc_attr($color); ?>;
            border-color:<?php echo esc_attr($color) ?>; background-color:<?php echo esc_attr($color) ?>;">
            <?php if( isset($font_icon) && $font_icon != '' ): ?><i class="<?php echo esc_attr($font_icon); ?>"></i><?php endif; ?>
            <div class="statistical-text clearfix" >
                <p id="<?php echo esc_attr($control_class);?>" class="counter"></p>
                <h2 class="title"><strong><?php echo esc_html($title); ?></strong></h2>
            </div>       
        </div>      
        <script type="text/javascript">
        jQuery(document).ready(function(){
            if(jQuery('.yolo-statistical-box').length>0) {
                var options = {
                  useEasing : true,
                  useGrouping : true,
                  separator : '',
                  decimal : '.',
                  prefix : '',
                  suffix : ''
                };
                jQuery('.yolo-statistical-box').waypoint(function(){
                    var numAnim = new CountUp("<?php echo esc_attr($control_class);?>", 0, <?php echo esc_html($number); ?>, 0, 6.5, options);
                    numAnim.start();
                }, { offset: '100%' });
            };
        })
         
        </script>
        <?php
        $yolo_title = ob_get_contents();
        ob_end_clean();
        return $yolo_title;
    }
    add_shortcode('yolo_statistical','yolo_shortcode_statistical');
}
?>