<?php

/**
 * Shortcode attributes
 * @var $teachers
 * @var $style
 * @var $columns
 * @var $post_per_page
 * @var $pagination
 * @var $text
 * @var $sub_text
 * @var $class
 */


if(!function_exists('yolo_teachers_shortcode')) {
	function yolo_teachers_shortcode($atts){
		extract( shortcode_atts( array(
			'teachers' 		=> 'all',
			'style' 		=> 'grid',
			'columns' 		=> 3,
			'posts_per_page' => 3,
			'pagination' 	=> 'show',
			'read_more'		=> true,	
			'pagination' 	=> 'hide',
			'excerpt_length'=> '55',
			'class' 		=> '',

		), $atts ) );
		
		ob_start();

		// Use this for pagination
		if( is_front_page() || is_home()) {
			$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : ( ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1 );
		} else {
			$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
		}

		$args = array(
			'paged'				=> $paged,
			'post_type' 		=> 'teacher',
			'post_status'		=> 'publish',
			'posts_per_page'	=> $posts_per_page,
			'orderby'			=> 'date',
			'order'				=> 'DESC'
		);

		if( $teachers != 'all' ) {
			$args['tax_query'] = array(
				'relation' => 'AND',
				array(
					'taxonomy' 		=> 'teacher_category',
					'field'    		=> 'term_id',
					'terms'    		=>  explode( ',', $teachers),
					'operator' 		=> 'IN',
				),
			);
		}

		$r = new WP_Query( $args );
		$grid_column = '';
		$grid_column .= (($style === 'grid' || $style === 'index-2' || $style === 'index-1') ? ' columns-'.$columns : '');
?>
		<div class="yolo-teachers <?php if($style != '') echo esc_attr($style);?> <?php if($style != '') echo esc_attr($class);?>">
			<ul class="teachers-info row is-flex">
				<?php if( $r->have_posts() ) : ?>
					<?php while( $r->have_posts() ) : $r->the_post();
					global $post;
					?>
					<li class = "<?php if($grid_column != '') echo esc_attr($grid_column);?>">
						<div class="yolo-teacher clearfix">
							<div class="teacher-image">
								<?php the_post_thumbnail(); ?>
								<div class="mask">
									<a href="<?php echo get_post_permalink(); ?>">
										<span class="icon"><span class="icon-square"><i class="fa fa-mail-forward"></i></span></span>
									</a>
								</div>
							</div>
							<div class="teacher-information">
								<div class="teacher-title">
									<h3><a href="<?php echo get_permalink(); ?>"><?php the_title(); ?></a></h3>
									<?php if( $category_list = get_the_term_list( get_the_ID(), 'teacher_category', '', ', ' ) ) : ?>
									<h4>
										<i class="fa fa-briefcase"></i> <?php echo $category_list; ?>
									</h4>
									<?php endif; ?>
								</div>
								<div class="teacher-social clearfix">
                                        <?php if( yolo_get_post_meta( get_the_ID(), '_yolo_wp_post_twitter' ) ) : ?>
                                        <span><a href="<?php echo esc_url( yolo_get_post_meta( get_the_ID(), '_yolo_wp_post_twitter' ) ); ?>"><i class="fa fa-twitter"></i></a></span>
                                        <?php endif; ?>
                                        <?php if( yolo_get_post_meta( get_the_ID(), '_yolo_wp_post_facebook' ) ) : ?>
                                        <span><a href="<?php echo esc_url( yolo_get_post_meta( get_the_ID(), '_yolo_wp_post_facebook' ) ); ?>"><i class="fa fa-facebook"></i></a></span>
                                        <?php endif; ?>
                                        <?php if( yolo_get_post_meta( get_the_ID(), '_yolo_wp_post_googleplus' ) ) : ?>
                                        <span><a href="<?php echo esc_url( yolo_get_post_meta( get_the_ID(), '_yolo_wp_post_googleplus' ) ); ?>"><i class="fa fa-google-plus"></i></a></span>
                                        <?php endif; ?>
                                        <?php if( yolo_get_post_meta( get_the_ID(), '_yolo_wp_post_linkedin' ) ) : ?>
                                        <span><a href="<?php echo esc_url( yolo_get_post_meta( get_the_ID(), '_yolo_wp_post_linkedin' ) ); ?>"><i class="fa fa-linkedin"></i></a></span>
                                        <?php endif; ?>
                                        <?php if( yolo_get_post_meta( get_the_ID(), '_yolo_wp_post_pinterest' ) ) : ?>
                                        <span><a href="<?php echo esc_url( yolo_get_post_meta( get_the_ID(), '_yolo_wp_post_pinterest' ) ); ?>"><i class="fa fa-pinterest"></i></a></span>
                                        <?php endif; ?>
                                        <?php if( yolo_get_post_meta( get_the_ID(), '_yolo_wp_post_instagram' ) != '' ) : ?>
                                        <span><a href="<?php echo esc_url( yolo_get_post_meta( get_the_ID(), '_yolo_wp_post_instagram' ) ); ?>"><i class="fa fa-instagram"></i></a></span>
                                        <?php endif; ?>
								</div>
								<div class="teacher-content">
									<div class="teacher-excerpt">
										<?php //the_excerpt(); 
										   $excerpt = $post->post_excerpt;
											if(empty($excerpt))
												$excerpt = $post->post_content;
											
											$excerpt = strip_shortcodes($excerpt);
											$excerpt = wp_trim_words($excerpt,$excerpt_length,'...');
										?>
										<p><?php echo esc_html($excerpt);?></p>
									</div>
									<?php if($read_more == true):?>
									<div class="teacher-readmore">
										<a class = "read-more" href="<?php echo get_post_permalink(); ?>"><?php esc_html_e( 'Read more', 'yolo-kidzone' ); ?></a>
									</div>
									<?php endif;?>
								</div>
							</div>
						</div>
					</li>
					<?php endwhile; ?>
				<?php endif; ?>
			</ul>
			<?php 
			if($pagination == 'show') {
				echo yolo_pagination_normal( $args, $r );
			}
			?>
		</div>
	<?php
	wp_reset_query();
	return ob_get_clean();
	}

	add_shortcode('yolo_teachers', 'yolo_teachers_shortcode');
}

?>