<?php

/*
 * Shortcode attributes
 */

if (!function_exists('yolo_shortcode_testimonial')) {

    function yolo_shortcode_testimonial($atts)
    {
        extract(shortcode_atts(array(
            'testimonials' => 'all',
            'style'        => 'style1',
            'columns'      => '1',
            'play'         => 'true'
            ),$atts));

        ob_start();
        $control_class = 'testimonials-list-'.uniqid();
        wp_enqueue_style('owl-carousel');
        wp_enqueue_script('owl-carousel');
        $args = array(
            'post_type'      => 'testimonial',
            'posts_per_page' => -1,
            'orderby'        => 'post_date',
            'order'          => 'DESC',
            'post_status'    => 'publish',
        );
        if( $testimonials != 'all' ){
            $args['post__in'] = explode(',', $testimonials);
        }

        $query = new WP_Query($args);
?>  
        <div class="yolo-testimonials <?php echo esc_attr($control_class); ?> <?php echo esc_attr($style); ?>">
            <i class="fa fa-quote-left"></i>
            <ul class="testimonial-list testimonials owl-carousel">
                <?php if ($query->have_posts()): ?>
                    <?php while ($query->have_posts()): $query->the_post();
                    $url = get_post_meta(get_the_ID(), '_yolo_wp_post_avatar', true);
                    $name = get_post_meta(get_the_ID(), '_yolo_wp_post_name', true);
                    $position = get_post_meta(get_the_ID(), '_yolo_wp_post_position', true);
                    $img = image_downsize($url, 'thumbnail');
                    ?>
                    <li>
                        <div class="yolo-testimonial testimonial-item">
                            <div class="yl-cm">
                                <?php if (isset($name)): ?>
                                    <h4 class="testimonial-name"><?php echo esc_html($name); ?></h4>
                                <?php endif; ?>
                                <?php if (isset($position)): ?>
                                    <p class="testimonial-position"><?php echo esc_html($position); ?></p>
                                <?php endif; ?>
                                <div class="testimonial-content">
                                    <?php the_content(); ?>
                                </div>
                            </div>
                            <div class="yl-img-name">
                                <img class="yl-img" src="<?php echo esc_url($img[0]); ?>" alt = "<?php echo esc_attr($name); ?>"/>
                                <p class="yl-name-under-image">
                                    <?php echo esc_html($name); ?>
                                </p>
                            </div>
                        </div>
                    </li>
                <?php endwhile; ?>
            <?php endif;
            wp_reset_postdata(); ?>
        </ul>
    </div>   
    <script>
        jQuery(document).ready(function($){
            var owl = $('.<?php echo esc_attr($control_class);?> .testimonial-list')
            owl.owlCarousel({
                autoplay: <?php echo ($play == 'true') ? 'true': 'false'; ?>,
                loop:true,
                margin: 10,
                dots: true,
                nav: true,
                navText: ["<i class='fa fa-chevron-left'></i>","<i class='fa fa-chevron-right'></i>"],
                dots: false,
                items : <?php echo $columns; ?>,
            });

        });
    </script>
<?php
         $testimonial = ob_get_contents();
         ob_end_clean();
         return $testimonial;
    }
    add_shortcode('yolo_testimonial', 'yolo_shortcode_testimonial');

}
?>