<?php

/**
 * Shortcode attributes
 * @var $courses
 * @var $filter
 * @var $monday_color
 * @var $title
 * @var $class
 */


if(!function_exists('yolo_timetable_shortcode')) {
	function yolo_timetable_shortcode($atts){
		extract( shortcode_atts( array(
			'title' 			=> '',
			'sub_title' 		=> '',
			'courses' 			=> 'all',
			'show_filter'		=> '',
			'filter'			=> 'button',
			'filter_position'   => '',
			'monday_color' 		=> '',
			'class' 			=> '',

		), $atts ) );		
		ob_start();
		$args = array(
			'post_type' 		=> 'course',
			'meta_key'   		=> '_course_class_time',
			'post_status'		=> 'publish',
			'orderby'    		=> 'meta_value_num',
			'order'				=> 'ASC',
			'posts_per_page'	=> -1
		);
		if( $courses != 'all' ) {
			$args['tax_query'] = array(
				'relation' => 'AND',
				array(
					'taxonomy' 		=> 'course_category',
					'field'    		=> 'term_id',
					'terms'    		=>  explode( ',', $courses),
					'operator' 		=> 'IN',
				),
			);
		}
		$r = new WP_Query( $args );
?>
		<!-- Timetable -->
		<div class="yolo-timetables timetable-wrapper">
			<div class="timetable-info">
				<div class="section-name">
					<div class="sep"></div>
					<h1><?php esc_html_e( $title, 'yolo-kidzone' ); ?></h1>
					<?php if($show_filter == 'true'):?>
						<div class="course-filter <?php if($filter_position != '') echo esc_attr($filter_position);?>">
							<!-- <button class="active btn" data-filter="time-table">Show All</button> -->
							<!-- Button style -->
							<?php if( $filter == "button" ) : ?>
							<button class="active btn" data-filter="course-all"><?php esc_html_e( 'All Courses', 'yolo-kidzone' ); ?></button>
							<?php if( $r->have_posts() ) : ?>
								<?php while( $r->have_posts() ) : $r->the_post(); ?>
								<button class="btn" data-filter="course-<?php the_ID(); ?>"><?php the_title(); ?></button>
								<?php endwhile; ?>
							<?php endif; ?>
							<?php endif; ?>

							<!-- List style -->
							<?php if( $filter == "list" ) : ?>
							<select id="course-filter">
								<option value="course-all" data-filter="course-all" selected><?php esc_html_e( 'All Courses', 'yolo-kidzone' ); ?></option>
								<?php if( $r->have_posts() ) : ?>
								<?php while( $r->have_posts() ) : $r->the_post(); ?>
							  	<option value="course-<?php the_ID(); ?>" data-filter="course-<?php the_ID(); ?>"><?php the_title(); ?></option>
							  	<?php endwhile; ?>
								<?php endif; ?>	
							</select>
							<?php endif; ?>
						</div>
					<?php endif;?>
				</div>
				
				<div id="yolo-timetable">
				<!-- Time table all courses -->
				<?php if( $r->have_posts() ) : ?>
					<?php while( $r->have_posts() ) : $r->the_post();	// global $post;
						$course_time 	= get_post_meta( get_the_ID(), '_course_class_time', true );

						// $course_time = array ( 'sunday' => $course_time['sunday']) + $course_time; 
						// unset($course_time[8]);
					?>
					<?php endwhile; ?>
				<?php endif;?>
					<!-- Timetable (Panels) -->
					<div class="time-table course-all" id="course-all">
						<!-- Panel  -->
						<?php foreach( $course_time as $key => $time ):?>
						<div class="panel time-cells <?php echo substr($key, 0, 3)?>">
							<!-- Heading -->
							<div class="panel-heading">
								<?php if('monday' == $key):?><h4><?php echo esc_html__('Monday','yolo-kidzone'); ?></h4><?php endif;?>
								<?php if('tuesday' == $key):?><h4><?php echo esc_html__('Tuesday','yolo-kidzone'); ?></h4><?php endif;?>
								<?php if('wednesday' == $key):?><h4><?php echo esc_html__('Webnesday','yolo-kidzone'); ?></h4><?php endif;?>
								<?php if('thursday' == $key):?><h4><?php echo esc_html__('Thursday','yolo-kidzone'); ?></h4><?php endif;?>
								<?php if('friday' == $key):?><h4><?php echo esc_html__('Friday','yolo-kidzone'); ?></h4><?php endif;?>
								<?php if('saturday' == $key):?><h4><?php echo esc_html__('Saturday','yolo-kidzone'); ?></h4><?php endif;?>
								<?php if('sunday' == $key):?><h4><?php echo esc_html__('Sunday','yolo-kidzone'); ?></h4><?php endif;?>
							</div>
							<!-- Panel Body -->
							<div class="panel-body">
								<!-- Time cell -->
								<?php if( $r->have_posts() ) : ?>
									<?php while( $r->have_posts() ) : $r->the_post();
										$new_course_time 		= yolo_get_post_meta( get_the_ID(), '_course_class_time', true );
										$course_teacher 		= get_post_meta( get_the_ID(), '_course_teacher', true );
										$teacher_name 			= get_the_title( $course_teacher );
									?>
										<?php foreach( $new_course_time as $new_key => $new_time ) : ?>
										<?php if( $key == $new_key && ($new_time['start'] !='') && ($new_time['end'] != '') ) : 
											// array_push($course_ff,$new_item['start']);
										?>
										<div class="time-cell big">
											<div class="time-cell-info <?php the_title(); ?>">
												<div class="time-cell-head">
													<h3><?php the_title(); ?></h3>
													<h5><?php echo $new_time['start']; ?> - <?php echo $new_time['end']; ?></h5>
												</div>
												<div class="time-cell-body">
													<?php if( ($course_teacher != true) || ($course_teacher != '') ) : ?>
													<h5><?php esc_html_e( 'Instructor', 'yolo-kidzone' ); ?>: <?php echo $teacher_name; ?></h5>
													<?php endif; ?>
													<!-- <h5>Room: 24</h5> -->
													<?php if( $category_list = get_the_term_list( get_the_ID(), 'course_level', '', ', ' ) ) : ?>
													<h5><?php esc_html_e( 'Level:', 'yolo-kidzone' ); ?> <?php echo strip_tags($category_list); ?></h5>
													<?php endif; ?>
												</div>
												<div class="time-detail">
													<a href="<?php echo get_post_permalink(); ?>"><i class="fa fa-chevron-circle-right"></i></a>
												</div>
											</div>
										</div>
										<?php endif; ?>
										<?php endforeach; ?>
									<?php endwhile; ?>
								<?php endif; ?>
							</div>
						</div>	
						<?php endforeach; ?>
					</div>
				<!-- End Time table all courses -->

				<!-- Time table each course -->
				<?php if( $r->have_posts() ) : ?>
				<?php while( $r->have_posts() ) : $r->the_post();
					$course_time 	= get_post_meta( get_the_ID(), '_course_class_time', true );
					$course_teacher 		= get_post_meta( get_the_ID(), '_course_teacher', true );
					$teacher_name 			= get_the_title( $course_teacher );

					// $course_time = array ( 'sunday' => $course_time['sunday']) + $course_time; 
					// unset($course_time[8]);
				?>
					<!-- Timetable (Panels) -->
					<div class="time-table course-<?php the_ID(); ?>" id="course-<?php the_ID(); ?>">
						<!-- Panel -->
						<?php foreach( $course_time as $key => $time ) : ?>
							<?php var_dump($key); ?>
						<div class="panel time-cells <?php echo substr($key, 0, 3)?>">
							<!-- Heading -->
							<div class="panel-heading">
								<h4><?php echo $key; ?></h4>
							</div>
							<!-- Panel Body -->
							<div class="panel-body">
								<!-- Time cell -->
								<?php if( ($time['start'] !='') && ($time['end'] != '') ) : ?>
								<div class="time-cell big">
									<div class = "time-cell-info">
										<div class="time-cell-head">
											<h3><?php the_title(); ?></h3>
											<h5><?php echo $time['start']; ?> - <?php echo $time['end']; ?></h5>
										</div>
										<div class="time-cell-body">
											<h5><?php esc_html_e( 'Instructor' ); ?>: <?php echo $teacher_name; ?></h5>
											<!-- <h5>Room: 24</h5> -->
											<?php if( $category_list = get_the_term_list( get_the_ID(), 'course_level', '', ', ' ) ) : ?>
											<h5><?php esc_html_e( 'Level:', 'yolo-kidzone' ); ?> <?php echo strip_tags($category_list); ?></h5>
											<?php endif; ?>
										</div>
										<div class="time-detail">
											<a href="<?php echo get_post_permalink(); ?>"><i class="fa fa-chevron-circle-right"></i></a>
										</div>
									</div>
								</div>
								<?php endif; ?>
							</div>
						</div>
						<?php endforeach; ?>
					</div>	
				<?php endwhile; ?>
				<?php endif; ?>
				<!-- End Time table each course -->
				</div>
				<!-- End Yolo Timetable content -->
			</div>
		</div>
		<!-- Script filter timetable -->
		<script>
		jQuery(document).ready(function($){
			var $boxs = $("#yolo-timetable > .time-table");
			// Show default filter
			$boxs.hide();
			$("#yolo-timetable > .time-table.course-all").show();

			// Filter by button
			<?php if( $filter == "button" ) : ?>
			var $btns = $(".btn").on("click", function() {
			  var active = 
			    $btns.removeClass("active")
			      .filter(this)
			      .addClass("active")
			      .data("filter");
			  $boxs
			    .hide()
			    .filter( "." + active )
			    .fadeIn(450);
			});
			<?php endif; ?>
			// Filter by dropdown list
			<?php if( $filter == "list" ) : ?>
			var $btns = $("#course-filter").on("change", function() {
				var course_selected = $(this).val();
				
				$boxs.hide();
				$("#yolo-timetable > .time-table." + course_selected).show("slow");
			});
			<?php endif; ?>
		})
		</script>

		<script>
		jQuery(document).ready(function($){
			var $boxs = $("#yolo-timetable > .time-table");
			// Show default filter
			$boxs.hide();
			$("#yolo-timetable > .time-table.course-all").show();
			
		})
		</script>

	<?php
	wp_reset_query();
	return ob_get_clean();
	}

	add_shortcode('yolo_timetable', 'yolo_timetable_shortcode');
}

?>