<?php
// Incremental ID Counter for Templates
if ( ! function_exists( 'yolo_vc_elements_id_increment' ) ) :
    function yolo_vc_elements_id_increment() {
        static $count = 0; $count++;
        return $count;
    }
endif;
// Function for handle element's visibility
if ( ! function_exists( 'yolo_visibility_class' ) ) :
    function yolo_visibility_class( $visibility = '' ) {
        switch ($visibility) {
            case 'hidden-phone':
                return ' hidden-xs';
            case 'hidden-tablet':
                return ' hidden-sm';
            case 'hidden-pc':
                return ' hidden-md hidden-lg';
            case 'visible-phone':
                return ' visible-xs';
            case 'visible-tablet':
                return ' visible-sm';
            case 'visible-pc':
                return ' visible-md visible-lg';
            default:
                return '';
        }
    }
endif;
if ( class_exists('WPBakeryVisualComposerAbstract') ):
    function yolo_theme_includevisual() {
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/map/new_params.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/map/map.php';
        // VC Templates
        $vc_templates_dir = YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/vc_templates/';
        vc_set_shortcodes_templates_dir($vc_templates_dir);
        
        wp_enqueue_style( 'select2', YOLO_PLUGIN_PATH.'assets/js/jquery.select2/select2.min.css', array(), 'all');
        // wp_enqueue_script( 'select2', YOLO_PLUGIN_PATH.'assets/js/jquery.select2/select2.full.min.js', array( 'jquery' ), false);

        // require file
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-service.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-clients.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-newsletter.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-testimonial.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-blog-post.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-recent-news.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-product-masonry.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-statistical.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-pricing-plans.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-image-slider.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-courses.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-teachers.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-events.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-portfolio.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-timetable.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-video.php';
        require_once YOLO_PLUGIN_SERVER_PATH . '/admin/vc_extension/shortcodes/yolo-search-post-type.php';
    }
    add_action('init', 'yolo_theme_includevisual', 20);
endif;

