<?php
/**
 * @package Yolo_Kidzone_Library
 */
/*
Plugin Name: Yolo Kidzone Library
Plugin URI: http://yolotheme.com/
Description: This is plugin for YoloTheme. This plugin allows you to create post types, taxonomies, Shortcode.
Version: 1.4.2
Author: YoloTheme
Author URI: http://yolotheme.com/
License: GPLv2 or later
*/


/**
 * This is the Yolo Posttype loader class.
 *
 * @package   Yolo_Posttype
 * @author    yolotheme (http:://yolotheme.com)
 * @copyright Copyright (c) 2015, YoloTheme
 */

if ( !class_exists('Yolo_Kidzone_Library') ):

    class Yolo_Kidzone_Library{

        /*
         * This method loads other methods of the class.
         */
        public function __construct(){
            /* load languages */
            $this -> yolo_load_languages();

            /*load all yolotheme*/
            $this -> yolo_load_yolotheme();
        }

        /*
         * Load the languages before everything else.
         */
        private function yolo_load_languages(){
            add_action( 'plugins_loaded', array( $this, 'yolo_load_textdomain' ) );
        }

        /*
         * Load the text domain.
         */
        public function yolo_load_textdomain(){
            load_plugin_textdomain('yolo-kidzone', false, dirname( plugin_basename( __FILE__ ) )  . '/languages/');
        }

        /*
         * Load Yolotheme on the 'after_setup_theme' action. Then filters will
         */
        public function yolo_load_yolotheme(){

            $this -> yolo_constants();

            $this -> yolo_admin_includes();


        }

        /**
         * Constants
         */
        private function yolo_constants(){
            define('YOLO_PLUGIN_PATH', plugin_dir_url( __FILE__ ));
            define('YOLO_PLUGIN_ASSETS_URI', plugin_dir_url( __FILE__ ).'/assets');
            define('YOLO_PLUGIN_SERVER_PATH',dirname( __FILE__ ) );
            define('YOLO_FRAMEWORK_URI', get_template_directory_uri() . '/includes' . '/framework' );
            define('YOLO_ADMIN_ASSETS_URI', get_template_directory_uri() . '/includes' . '/admin_assets' );
        }

        /*
         * Require file
         */
        private function  yolo_admin_includes(){
            require_once YOLO_PLUGIN_SERVER_PATH.'/admin/importer/yolo-setup-install.php';
            require_once YOLO_PLUGIN_SERVER_PATH.'/admin/post-type/function-init.php';
            require_once YOLO_PLUGIN_SERVER_PATH.'/admin/vc_extension/vc_init.php';
        }

    }
    $oj_yoloplugin = new Yolo_Kidzone_Library();

endif;

if( !function_exists('yolo_get_option') ) {
    // Normal get option
    function yolo_get_option( $option, $default = null ) {
        $value = get_theme_mod( $option, $default );
        $value = ( $value === null || $value === '' ) ? $default : $value;
        return apply_filters( 'yolo_theme_settings', $value, $option, $default );
    }
}
require_once dirname( __FILE__ ) . '/admin/mailchimp/MCAPI.class.php';
